/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.LocalDateTimeUtil;
import cn.nxtools.common.StringUtil;
import cn.nxtools.common.base.Objects;
import cn.nxtools.common.base.Preconditions;
import cn.nxtools.common.time.DateUnit;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String HH_MM_SS = "HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS_SSS_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final String YYYY_MM_DD_FORMAT = "yyyy/MM/dd";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";

    private DateUtil() {
    }

    public static Date now() {
        return new Date();
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long currentTimeNanos() {
        return DateUtil.currentTimeMillis() * 1000000L + System.nanoTime() % 1000000L;
    }

    public static String toString(Date date) {
        return DateUtil.toString(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static String toString(Date date, String format) {
        LocalDateTime localDateTime = LocalDateTimeUtil.ofDate(date);
        if (Objects.isNull(localDateTime)) {
            return null;
        }
        return LocalDateTimeUtil.toString(localDateTime, format);
    }

    public static Date of(String dateStr, String format) {
        if (StringUtil.isEmpty(dateStr)) {
            return null;
        }
        Preconditions.checkNotNull(format);
        LocalDateTime localDateTime = LocalDateTimeUtil.ofString(dateStr, format);
        Date date = LocalDateTimeUtil.toDate(localDateTime);
        return date;
    }

    public static Date format(String dateStr, String format) {
        return DateUtil.of(dateStr, format);
    }

    public static Date addYears(Date date, int years) {
        return DateUtil.add(date, 1, years);
    }

    public static Date addMonths(Date date, int months) {
        return DateUtil.add(date, 2, months);
    }

    public static Date addWeeks(Date date, int weeks) {
        return DateUtil.add(date, 3, weeks);
    }

    public static Date addDays(Date date, int days) {
        return DateUtil.add(date, 5, days);
    }

    public static Date addHours(Date date, int hours) {
        return DateUtil.add(date, 11, hours);
    }

    public static Date addMinutes(Date date, int minutes) {
        return DateUtil.add(date, 12, minutes);
    }

    public static Date addSeconds(Date date, int seconds) {
        return DateUtil.add(date, 13, seconds);
    }

    public static Date addMilliseconds(Date date, int milliseconds) {
        return DateUtil.add(date, 14, milliseconds);
    }

    public static Date add(Date date, int calendarField, int param) {
        Preconditions.checkNotNull(date);
        Calendar c = DateUtil.toCalendar(date);
        c.add(calendarField, param);
        return c.getTime();
    }

    public static Calendar toCalendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static Calendar toCalendar(Date date, TimeZone timeZone) {
        Calendar c = Calendar.getInstance(timeZone);
        c.setTime(date);
        return c;
    }

    public static Date beginOfDay(Date date) {
        LocalDateTime dateTime = LocalDateTimeUtil.beginOfDay(LocalDateTimeUtil.ofDate(date));
        return LocalDateTimeUtil.toDate(dateTime);
    }

    public static Date endOfDay(Date date) {
        LocalDateTime dateTime = LocalDateTimeUtil.endOfDay(LocalDateTimeUtil.ofDate(date));
        return LocalDateTimeUtil.toDate(dateTime);
    }

    public static long diff(Date begin, Date end, DateUnit dateUnit) {
        Preconditions.checkNotNull(begin, "begin date must be not null");
        Preconditions.checkNotNull(end, "end Date must be not null");
        dateUnit = Objects.defaultIfNull(dateUnit, DateUnit.MILLISECOND);
        long diff = end.getTime() - begin.getTime();
        return diff / dateUnit.getMillis();
    }
}

