/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static boolean isNull(Collection<?> collection) {
        return collection == null;
    }

    public static boolean isNotNull(Collection<?> collection) {
        return collection != null;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isNull(Map<?, ?> map) {
        return map == null;
    }

    public static boolean isNotNull(Map<?, ?> map) {
        return map != null;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static <T, K, V> Map<K, V> toMap(Iterable<T> iterable, Function<T, K> key, Function<T, V> value) {
        return CollectionUtil.toMap(Maps.newHashMap(), iterable, key, value);
    }

    public static <T, K, V> Map<K, V> toMap(Map<K, V> map, Iterable<T> iterable, Function<T, K> key, Function<T, V> value) {
        if (iterable == null) {
            return map;
        }
        if (map == null) {
            map = Maps.newHashMap();
        }
        for (T t : iterable) {
            if (t == null) {
                map.put(null, null);
                continue;
            }
            map.put(key.apply(t), value.apply(t));
        }
        return map;
    }
}

