/*
 * Decompiled with CFR 0.152.
 */
package cn.nxtools.common;

import cn.nxtools.common.StringUtil;
import cn.nxtools.common.base.Objects;
import cn.nxtools.common.collect.Sets;
import java.util.Set;

public class BooleanUtil {
    private static final Set<String> TRUE_SET = Sets.newHashSet("true", "1", "yes", "y", "\u771f", "\u5bf9", "on");

    public static boolean isTrue(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public static boolean isFalse(Boolean bool) {
        return Boolean.FALSE.equals(bool);
    }

    public static boolean toBoolean(String value) {
        if (StringUtil.isNotEmpty(value)) {
            value = value.toLowerCase();
            return TRUE_SET.contains(value);
        }
        return false;
    }

    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    public static long toLong(boolean value) {
        return BooleanUtil.toInt(value);
    }

    public static Boolean toBoolean(Long value, Boolean nullValue) {
        if (Objects.isNull(value)) {
            return nullValue;
        }
        if (value.compareTo(0L) == 0) {
            return false;
        }
        return true;
    }

    public static Boolean toBoolean(Integer value, Boolean defaultValue) {
        if (Objects.isNull(value)) {
            return defaultValue;
        }
        if (value.compareTo(0) == 0) {
            return false;
        }
        return true;
    }
}

