package cn.nxtools.common.text;

/**
 * @author niuchangqing
 * 字符串常量池
 * @since 1.0.4
 */
public interface StringPool {
    /**
     * "" 字符串
     */
    String EMPTY = "";

    /**
     * "null" 字符串常量
     */
    String NULL = "null";

    /**
     * " " 空字符串
     */
    String SPACE = " ";

    /**
     * 空 JSON字符串 {@code "{}"}
     * @since 1.0.4
     */
    String EMPTY_JSON = "{}";

    /**
     * {@code "@"}符号字符
     * @since 1.0.4
     */
    String AT = "@";
}
