/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.video.recording;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.hutool.core.thread.ThreadUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import org.apache.commons.lang.StringUtils;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameRecorder;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ScreenRecorder {
    private static final Logger log = LoggerFactory.getLogger(ScreenRecorder.class);
    private static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();
    private static FFmpegFrameRecorder recorder;
    private static AudioFormat audioFormat;
    private static Robot robot;
    private static DataLine.Info dataLineInfo;
    private static TargetDataLine line;
    private static ScheduledThreadPoolExecutor screenThreadPool;
    private static ScheduledThreadPoolExecutor audioThreadPool;
    private long pauseTime = 0L;
    private int width;
    private int height;
    private int videoCodec;
    private int audioCodec;
    private String format;
    private int sampleRate;
    private int frameRate;
    private int gopSize;
    private int videoQuality;
    private int audioQuality;
    private int videoBitrate;
    private int audioBitrate;
    private String crf;
    private String preset;
    private int pixelFormat;
    private int audioChannels;
    private String saveTo;
    private boolean isAudioRecorder;
    private int corePoolSize;
    private static final String INIT = "init";
    private static final String START = "start";
    private static final String PAUSE = "pause";
    private static final String STOP = "stop";
    private static String current;

    public ScreenRecorder() {
        this.width = ScreenRecorder.TOOLKIT.getScreenSize().width;
        this.height = ScreenRecorder.TOOLKIT.getScreenSize().height;
        this.videoCodec = 12;
        this.audioCodec = 86018;
        this.format = "mp4";
        this.sampleRate = 48000;
        this.frameRate = 10;
        this.gopSize = this.frameRate * 2;
        this.videoQuality = 0;
        this.audioQuality = 0;
        this.videoBitrate = 2000000;
        this.audioBitrate = 192000;
        this.crf = "25";
        this.preset = "slow";
        this.pixelFormat = 0;
        this.audioChannels = 2;
        this.saveTo = System.getProperty("user.dir");
        this.isAudioRecorder = true;
        this.corePoolSize = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getVideoCodec() {
        return this.videoCodec;
    }

    public void setVideoCodec(int videoCodec) {
        this.videoCodec = videoCodec;
    }

    public int getAudioCodec() {
        return this.audioCodec;
    }

    public void setAudioCodec(int audioCodec) {
        this.audioCodec = audioCodec;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    public int getGopSize() {
        return this.gopSize;
    }

    public void setGopSize(int gopSize) {
        this.gopSize = gopSize;
    }

    public int getVideoQuality() {
        return this.videoQuality;
    }

    public void setVideoQuality(int videoQuality) {
        this.videoQuality = videoQuality;
    }

    public int getAudioQuality() {
        return this.audioQuality;
    }

    public void setAudioQuality(int audioQuality) {
        this.audioQuality = audioQuality;
    }

    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    public void setVideoBitrate(int videoBitrate) {
        this.videoBitrate = videoBitrate;
    }

    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    public void setAudioBitrate(int audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public String getCrf() {
        return this.crf;
    }

    public void setCrf(String crf) {
        this.crf = crf;
    }

    public String getPreset() {
        return this.preset;
    }

    public void setPreset(String preset) {
        this.preset = preset;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(int pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public int getAudioChannels() {
        return this.audioChannels;
    }

    public void setAudioChannels(int audioChannels) {
        this.audioChannels = audioChannels;
    }

    public String getSaveTo() {
        return this.saveTo;
    }

    public void setSaveTo(String saveTo) {
        this.saveTo = saveTo;
    }

    public boolean isAudioRecorder() {
        return this.isAudioRecorder;
    }

    public void setAudioRecorder(boolean audioRecorder) {
        this.isAudioRecorder = audioRecorder;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    private void init(Object file) {
        String fileName = this.saveTo + File.separatorChar + file.toString() + ".mp4";
        recorder = new FFmpegFrameRecorder(fileName, this.width, this.height);
        recorder.setVideoCodec(this.videoCodec);
        recorder.setFormat(this.format);
        recorder.setSampleRate(this.sampleRate);
        recorder.setFrameRate((double)this.frameRate);
        recorder.setVideoQuality((double)this.videoQuality);
        recorder.setVideoOption("crf", this.crf);
        recorder.setVideoOption("preset", this.preset);
        recorder.setVideoBitrate(this.videoBitrate);
        recorder.setPixelFormat(this.pixelFormat);
        recorder.setAudioChannels(this.audioChannels);
        recorder.setAudioOption("crf", "0");
        recorder.setAudioQuality((double)this.audioQuality);
        recorder.setAudioCodec(this.audioCodec);
        recorder.setGopSize(this.gopSize);
        recorder.setAudioBitrate(this.audioBitrate);
        current = START;
        try {
            robot = new Robot();
        }
        catch (AWTException e) {
            log.error("\u521d\u59cb\u5316\u5c4f\u5e55\u622a\u56fe\u5f02\u5e38:" + e.getMessage());
        }
        try {
            recorder.start();
        }
        catch (FrameRecorder.Exception e) {
            log.error("\u521d\u59cb\u5316\u7f16\u7801\u5668\u5f02\u5e38:" + e.getMessage());
        }
    }

    public void start() {
        this.start(String.valueOf(System.currentTimeMillis()));
    }

    public void start(String file) {
        if (StringUtils.isBlank((String)file)) {
            file = String.valueOf(System.currentTimeMillis());
        }
        if (current.equals(INIT)) {
            this.init(file);
        }
        if (!current.equals(START) && !current.equals(PAUSE)) {
            return;
        }
        current = STOP;
        if (this.isAudioRecorder) {
            ThreadUtil.execute(this::soundRecorder);
        }
        screenThreadPool = new ScheduledThreadPoolExecutor(this.corePoolSize, new ThreadFactoryBuilder().build());
        Rectangle rectangle = new Rectangle(this.width, this.height);
        if (this.pauseTime == 0L) {
            this.pauseTime = System.currentTimeMillis();
        }
        long startTime = System.currentTimeMillis();
        screenThreadPool.scheduleAtFixedRate(() -> {
            try {
                BufferedImage screenCapture = robot.createScreenCapture(rectangle);
                BufferedImage videoImg = new BufferedImage(this.width, this.height, 5);
                Graphics2D videoGraphics = videoImg.createGraphics();
                videoGraphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                videoGraphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                videoGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                videoGraphics.drawImage((Image)screenCapture, 0, 0, null);
                Java2DFrameConverter java2dConverter = new Java2DFrameConverter();
                Frame frame = java2dConverter.convert(videoImg);
                long videoTs = 1000L * (System.currentTimeMillis() - startTime - (System.currentTimeMillis() - this.pauseTime));
                if (videoTs > recorder.getTimestamp()) {
                    recorder.setTimestamp(videoTs);
                }
                recorder.record(frame);
                frame.clone();
                videoGraphics.dispose();
                videoImg.flush();
                screenCapture.flush();
            }
            catch (Exception e) {
                log.error("\u89c6\u9891\u5f55\u5236\u7ebf\u7a0b\u5f02\u5e38:" + e.getMessage());
            }
        }, 1000 / this.frameRate, 1000 / this.frameRate, TimeUnit.MILLISECONDS);
        System.gc();
    }

    private void soundRecorder() {
        audioFormat = new AudioFormat(this.sampleRate, 16, this.audioChannels, true, false);
        dataLineInfo = new DataLine.Info(TargetDataLine.class, audioFormat);
        try {
            line = (TargetDataLine)AudioSystem.getLine(dataLineInfo);
            line.open(audioFormat);
            line.start();
            int sampleRate = (int)audioFormat.getSampleRate();
            int numChannels = audioFormat.getChannels();
            int audioBufferSize = sampleRate * numChannels;
            byte[] audioBytes = new byte[audioBufferSize];
            audioThreadPool = new ScheduledThreadPoolExecutor(this.corePoolSize, new ThreadFactoryBuilder().build());
            audioThreadPool.scheduleAtFixedRate(() -> {
                try {
                    int nBytesRead = line.read(audioBytes, 0, line.available());
                    int nSamplesRead = nBytesRead / 2;
                    short[] samples = new short[nSamplesRead];
                    ByteBuffer.wrap(audioBytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(samples);
                    ShortBuffer sBuff = ShortBuffer.wrap(samples, 0, nSamplesRead);
                    recorder.recordSamples(sampleRate, numChannels, new Buffer[]{sBuff});
                }
                catch (FrameRecorder.Exception e) {
                    log.error("\u58f0\u97f3\u6293\u53d6\u7ebf\u7a0b\u5f02\u5e38:" + e.getMessage());
                }
            }, 1000 / this.frameRate, 1000 / this.frameRate, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("\u58f0\u97f3\u6293\u53d6\u65b9\u6cd5\u4f53\u5f02\u5e38:" + e.getMessage());
        }
    }

    public void pause() {
        if (!current.equals(STOP)) {
            return;
        }
        current = PAUSE;
        if (screenThreadPool != null) {
            screenThreadPool.shutdown();
        }
        this.stopAudio();
        screenThreadPool = null;
        this.pauseTime = System.currentTimeMillis();
        System.gc();
    }

    public void stop() {
        if (!current.equals(STOP) && !current.equals(PAUSE)) {
            return;
        }
        current = INIT;
        try {
            if (screenThreadPool != null) {
                screenThreadPool.shutdownNow();
            }
            recorder.stop();
            recorder.release();
            recorder.close();
            recorder = null;
            this.stopAudio();
            screenThreadPool = null;
            this.pauseTime = 0L;
            System.gc();
        }
        catch (Exception e) {
            log.error("stop\u65b9\u6cd5\u4f53\u6267\u884c\u5f02\u5e38:" + e.getMessage());
        }
    }

    private void stopAudio() {
        if (this.isAudioRecorder) {
            if (audioThreadPool != null) {
                audioThreadPool.shutdown();
            }
            if (line != null) {
                line.stop();
                line.close();
            }
            dataLineInfo = null;
            audioFormat = null;
            line = null;
            audioThreadPool = null;
        }
    }

    static {
        current = INIT;
    }
}

