/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.video.pojo;

import cn.novelweb.video.pojo.Preset;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.javacv.FrameGrabber;

public class VideoParameters {
    @ApiModelProperty(value="\u89c6\u9891\u7684\u5bbd\u5ea6")
    private int width;
    @ApiModelProperty(value="\u89c6\u9891\u7684\u9ad8\u5ea6")
    private int height;
    @ApiModelProperty(value="\u89c6\u9891\u7f16\u89e3\u7801\u5668\u3001\u89c6\u9891\u7684\u538b\u7f29\u65b9\u5f0f\u3001\u89c6\u9891\u89e3\u7801")
    private int videoCodec;
    @ApiModelProperty(value="\u97f3\u8baf\u7f16\u89e3\u7801\u5668;\u97f3\u9891\u7f16\u7801\u683c\u5f0f;\u97f3\u9891\u7f16\u89e3\u7801;")
    private int audioCodec;
    @ApiModelProperty(value="\u786e\u5b9a\u89c6\u9891\u683c\u5f0f[\u5982:flv\u3001mp4]")
    private String format;
    @ApiModelProperty(value="\u97f3\u9891\u91c7\u6837\u7387")
    private int sampleRate;
    @ApiModelProperty(value="\u5e27\u9891,\u5e27\u901f\u7387")
    private double frameRate;
    @ApiModelProperty(value="\u8bbe\u5b9a\u56fa\u5b9a\u89c6\u9891\u6bd4\u7279\u7387")
    private int videoBitrate;
    @ApiModelProperty(value="\u8bbe\u7f6e\u56fa\u5b9a\u7684\u97f3\u9891\u6bd4\u7279\u7387")
    private int audioBitrate;
    @ApiModelProperty(value="\u8bbe\u7f6e\u50cf\u7d20\u683c\u5f0f")
    private int pixelFormat;
    @ApiModelProperty(value="\u8bbe\u7f6e\u97f3\u9891\u7684\u58f0\u9053[2(\u7acb\u4f53\u58f0);1(\u5355\u58f0\u9053);0(\u65e0\u97f3\u9891)]")
    private int audioChannels;
    @ApiModelProperty(value="\u89c6\u9891\u7684\u65f6\u957f[\u5355\u4f4d:\u79d2]")
    private long videoLengthTime;
    @ApiModelProperty(value="\u6846\u67b6\u957f\u5ea6")
    private int lengthInFrames;
    @ApiModelProperty(value="\u97f3\u9891\u5e27\u957f\u5ea6")
    private int lengthInAudioFrames;
    @ApiModelProperty(value="\u89c6\u9891\u6d41")
    private int videoStream;
    @ApiModelProperty(value="\u89c6\u9891\u9009\u9879;\u663e\u793a\u9009\u9879")
    private Map<String, String> videoOptions;
    @ApiModelProperty(value="\u89c6\u9891\u7f16\u89e3\u7801\u5668\u540d\u79f0")
    private String videoCodecName;
    @ApiModelProperty(value="\u5143\u6570\u636e;\u5143\u8d44\u6599")
    private Map<String, String> metadata;
    @ApiModelProperty(value="\u8d85\u65f6")
    private int timeout;
    @ApiModelProperty(value="\u4f20\u611f\u5668\u6a21\u5f0f")
    private long sensorPattern;
    @ApiModelProperty(value="\u91c7\u6837\u6a21\u5f0f;\u53d6\u6837\u65b9\u5f0f")
    private FrameGrabber.SampleMode sampleMode;
    @ApiModelProperty(value="\u5c4f\u5e55\u7eb5\u6a2a\u6bd4;\u5c4f\u5e55\u957f\u5bbd\u6bd4")
    private double aspectRatio;
    @ApiModelProperty(value="\u5c4f\u5e55\u7eb5\u6a2a\u6bd4;\u5c4f\u5e55\u957f\u5bbd\u6bd4")
    private double numBuffers;
    @ApiModelProperty(value="\u6700\u5927\u5ef6\u8fdf")
    private int maxDelay;
    @ApiModelProperty(value="\u56fe\u50cf\u7f29\u653e\u6807\u5fd7")
    private int imageScalingFlags;
    @ApiModelProperty(value="\u4f3d\u9a6c\u5206\u5e03")
    private double gamma;
    @ApiModelProperty(value="\u683c\u5f0f\u4e0a\u4e0b\u6587")
    private AVFormatContext formatContext;
    @ApiModelProperty(value="\u6bcf\u4e2a\u50cf\u7d20\u7684\u4f4d\u6570")
    private int bitsPerPixel;
    @ApiModelProperty(value="\u65f6\u95f4\u6233")
    private long timestamp;
    @ApiModelProperty(value="\u97f3\u9891\u6d41;\u58f0\u97f3\u4e32\u6d41")
    private int audioStream;
    @ApiModelProperty(value="\u5173\u952e\u5e27\u95f4\u9694,\u4e00\u822c\u4e0e\u5e27\u7387\u76f8\u540c\u6216\u8005\u662f\u89c6\u9891\u5e27\u7387\u7684\u4e24\u500d")
    private int gopSize;
    @ApiModelProperty(value="\u89c6\u9891\u8d28\u91cf")
    private double videoQuality = -1.0;
    @ApiModelProperty(value="\u97f3\u9891\u7684\u8d28\u91cf")
    private double audioQuality = -1.0;
    @ApiModelProperty(value="\u6743\u8861 \u89c6\u9891\u8d28\u91cf \u548c \u7f16\u7801\u901f\u5ea6 \u7684\u503c")
    private Preset preset = Preset.slow;

    public static VideoParametersBuilder builder() {
        return new VideoParametersBuilder();
    }

    public VideoParameters() {
    }

    public VideoParameters(int width, int height, int videoCodec, int audioCodec, String format, int sampleRate, double frameRate, int videoBitrate, int audioBitrate, int pixelFormat, int audioChannels, long videoLengthTime, int lengthInFrames, int lengthInAudioFrames, int videoStream, Map<String, String> videoOptions, String videoCodecName, Map<String, String> metadata, int timeout, long sensorPattern, FrameGrabber.SampleMode sampleMode, double aspectRatio, double numBuffers, int maxDelay, int imageScalingFlags, double gamma, AVFormatContext formatContext, int bitsPerPixel, long timestamp, int audioStream, int gopSize, double videoQuality, double audioQuality, Preset preset) {
        this.width = width;
        this.height = height;
        this.videoCodec = videoCodec;
        this.audioCodec = audioCodec;
        this.format = format;
        this.sampleRate = sampleRate;
        this.frameRate = frameRate;
        this.videoBitrate = videoBitrate;
        this.audioBitrate = audioBitrate;
        this.pixelFormat = pixelFormat;
        this.audioChannels = audioChannels;
        this.videoLengthTime = videoLengthTime;
        this.lengthInFrames = lengthInFrames;
        this.lengthInAudioFrames = lengthInAudioFrames;
        this.videoStream = videoStream;
        this.videoOptions = videoOptions;
        this.videoCodecName = videoCodecName;
        this.metadata = metadata;
        this.timeout = timeout;
        this.sensorPattern = sensorPattern;
        this.sampleMode = sampleMode;
        this.aspectRatio = aspectRatio;
        this.numBuffers = numBuffers;
        this.maxDelay = maxDelay;
        this.imageScalingFlags = imageScalingFlags;
        this.gamma = gamma;
        this.formatContext = formatContext;
        this.bitsPerPixel = bitsPerPixel;
        this.timestamp = timestamp;
        this.audioStream = audioStream;
        this.gopSize = gopSize;
        this.videoQuality = videoQuality;
        this.audioQuality = audioQuality;
        this.preset = preset;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getVideoCodec() {
        return this.videoCodec;
    }

    public int getAudioCodec() {
        return this.audioCodec;
    }

    public String getFormat() {
        return this.format;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public int getAudioChannels() {
        return this.audioChannels;
    }

    public long getVideoLengthTime() {
        return this.videoLengthTime;
    }

    public int getLengthInFrames() {
        return this.lengthInFrames;
    }

    public int getLengthInAudioFrames() {
        return this.lengthInAudioFrames;
    }

    public int getVideoStream() {
        return this.videoStream;
    }

    public Map<String, String> getVideoOptions() {
        return this.videoOptions;
    }

    public String getVideoCodecName() {
        return this.videoCodecName;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getSensorPattern() {
        return this.sensorPattern;
    }

    public FrameGrabber.SampleMode getSampleMode() {
        return this.sampleMode;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public double getNumBuffers() {
        return this.numBuffers;
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public int getImageScalingFlags() {
        return this.imageScalingFlags;
    }

    public double getGamma() {
        return this.gamma;
    }

    public AVFormatContext getFormatContext() {
        return this.formatContext;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getAudioStream() {
        return this.audioStream;
    }

    public int getGopSize() {
        return this.gopSize;
    }

    public double getVideoQuality() {
        return this.videoQuality;
    }

    public double getAudioQuality() {
        return this.audioQuality;
    }

    public Preset getPreset() {
        return this.preset;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setVideoCodec(int videoCodec) {
        this.videoCodec = videoCodec;
    }

    public void setAudioCodec(int audioCodec) {
        this.audioCodec = audioCodec;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void setFrameRate(double frameRate) {
        this.frameRate = frameRate;
    }

    public void setVideoBitrate(int videoBitrate) {
        this.videoBitrate = videoBitrate;
    }

    public void setAudioBitrate(int audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public void setPixelFormat(int pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public void setAudioChannels(int audioChannels) {
        this.audioChannels = audioChannels;
    }

    public void setVideoLengthTime(long videoLengthTime) {
        this.videoLengthTime = videoLengthTime;
    }

    public void setLengthInFrames(int lengthInFrames) {
        this.lengthInFrames = lengthInFrames;
    }

    public void setLengthInAudioFrames(int lengthInAudioFrames) {
        this.lengthInAudioFrames = lengthInAudioFrames;
    }

    public void setVideoStream(int videoStream) {
        this.videoStream = videoStream;
    }

    public void setVideoOptions(Map<String, String> videoOptions) {
        this.videoOptions = videoOptions;
    }

    public void setVideoCodecName(String videoCodecName) {
        this.videoCodecName = videoCodecName;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setSensorPattern(long sensorPattern) {
        this.sensorPattern = sensorPattern;
    }

    public void setSampleMode(FrameGrabber.SampleMode sampleMode) {
        this.sampleMode = sampleMode;
    }

    public void setAspectRatio(double aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public void setNumBuffers(double numBuffers) {
        this.numBuffers = numBuffers;
    }

    public void setMaxDelay(int maxDelay) {
        this.maxDelay = maxDelay;
    }

    public void setImageScalingFlags(int imageScalingFlags) {
        this.imageScalingFlags = imageScalingFlags;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public void setFormatContext(AVFormatContext formatContext) {
        this.formatContext = formatContext;
    }

    public void setBitsPerPixel(int bitsPerPixel) {
        this.bitsPerPixel = bitsPerPixel;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setAudioStream(int audioStream) {
        this.audioStream = audioStream;
    }

    public void setGopSize(int gopSize) {
        this.gopSize = gopSize;
    }

    public void setVideoQuality(double videoQuality) {
        this.videoQuality = videoQuality;
    }

    public void setAudioQuality(double audioQuality) {
        this.audioQuality = audioQuality;
    }

    public void setPreset(Preset preset) {
        this.preset = preset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoParameters)) {
            return false;
        }
        VideoParameters other = (VideoParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getVideoCodec() != other.getVideoCodec()) {
            return false;
        }
        if (this.getAudioCodec() != other.getAudioCodec()) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        if (this.getSampleRate() != other.getSampleRate()) {
            return false;
        }
        if (Double.compare(this.getFrameRate(), other.getFrameRate()) != 0) {
            return false;
        }
        if (this.getVideoBitrate() != other.getVideoBitrate()) {
            return false;
        }
        if (this.getAudioBitrate() != other.getAudioBitrate()) {
            return false;
        }
        if (this.getPixelFormat() != other.getPixelFormat()) {
            return false;
        }
        if (this.getAudioChannels() != other.getAudioChannels()) {
            return false;
        }
        if (this.getVideoLengthTime() != other.getVideoLengthTime()) {
            return false;
        }
        if (this.getLengthInFrames() != other.getLengthInFrames()) {
            return false;
        }
        if (this.getLengthInAudioFrames() != other.getLengthInAudioFrames()) {
            return false;
        }
        if (this.getVideoStream() != other.getVideoStream()) {
            return false;
        }
        Map<String, String> this$videoOptions = this.getVideoOptions();
        Map<String, String> other$videoOptions = other.getVideoOptions();
        if (this$videoOptions == null ? other$videoOptions != null : !((Object)this$videoOptions).equals(other$videoOptions)) {
            return false;
        }
        String this$videoCodecName = this.getVideoCodecName();
        String other$videoCodecName = other.getVideoCodecName();
        if (this$videoCodecName == null ? other$videoCodecName != null : !this$videoCodecName.equals(other$videoCodecName)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getSensorPattern() != other.getSensorPattern()) {
            return false;
        }
        FrameGrabber.SampleMode this$sampleMode = this.getSampleMode();
        FrameGrabber.SampleMode other$sampleMode = other.getSampleMode();
        if (this$sampleMode == null ? other$sampleMode != null : !this$sampleMode.equals(other$sampleMode)) {
            return false;
        }
        if (Double.compare(this.getAspectRatio(), other.getAspectRatio()) != 0) {
            return false;
        }
        if (Double.compare(this.getNumBuffers(), other.getNumBuffers()) != 0) {
            return false;
        }
        if (this.getMaxDelay() != other.getMaxDelay()) {
            return false;
        }
        if (this.getImageScalingFlags() != other.getImageScalingFlags()) {
            return false;
        }
        if (Double.compare(this.getGamma(), other.getGamma()) != 0) {
            return false;
        }
        AVFormatContext this$formatContext = this.getFormatContext();
        AVFormatContext other$formatContext = other.getFormatContext();
        if (this$formatContext == null ? other$formatContext != null : !this$formatContext.equals(other$formatContext)) {
            return false;
        }
        if (this.getBitsPerPixel() != other.getBitsPerPixel()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getAudioStream() != other.getAudioStream()) {
            return false;
        }
        if (this.getGopSize() != other.getGopSize()) {
            return false;
        }
        if (Double.compare(this.getVideoQuality(), other.getVideoQuality()) != 0) {
            return false;
        }
        if (Double.compare(this.getAudioQuality(), other.getAudioQuality()) != 0) {
            return false;
        }
        Preset this$preset = this.getPreset();
        Preset other$preset = other.getPreset();
        return !(this$preset == null ? other$preset != null : !((Object)((Object)this$preset)).equals((Object)other$preset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VideoParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getVideoCodec();
        result = result * 59 + this.getAudioCodec();
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        result = result * 59 + this.getSampleRate();
        long $frameRate = Double.doubleToLongBits(this.getFrameRate());
        result = result * 59 + (int)($frameRate >>> 32 ^ $frameRate);
        result = result * 59 + this.getVideoBitrate();
        result = result * 59 + this.getAudioBitrate();
        result = result * 59 + this.getPixelFormat();
        result = result * 59 + this.getAudioChannels();
        long $videoLengthTime = this.getVideoLengthTime();
        result = result * 59 + (int)($videoLengthTime >>> 32 ^ $videoLengthTime);
        result = result * 59 + this.getLengthInFrames();
        result = result * 59 + this.getLengthInAudioFrames();
        result = result * 59 + this.getVideoStream();
        Map<String, String> $videoOptions = this.getVideoOptions();
        result = result * 59 + ($videoOptions == null ? 43 : ((Object)$videoOptions).hashCode());
        String $videoCodecName = this.getVideoCodecName();
        result = result * 59 + ($videoCodecName == null ? 43 : $videoCodecName.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        result = result * 59 + this.getTimeout();
        long $sensorPattern = this.getSensorPattern();
        result = result * 59 + (int)($sensorPattern >>> 32 ^ $sensorPattern);
        FrameGrabber.SampleMode $sampleMode = this.getSampleMode();
        result = result * 59 + ($sampleMode == null ? 43 : $sampleMode.hashCode());
        long $aspectRatio = Double.doubleToLongBits(this.getAspectRatio());
        result = result * 59 + (int)($aspectRatio >>> 32 ^ $aspectRatio);
        long $numBuffers = Double.doubleToLongBits(this.getNumBuffers());
        result = result * 59 + (int)($numBuffers >>> 32 ^ $numBuffers);
        result = result * 59 + this.getMaxDelay();
        result = result * 59 + this.getImageScalingFlags();
        long $gamma = Double.doubleToLongBits(this.getGamma());
        result = result * 59 + (int)($gamma >>> 32 ^ $gamma);
        AVFormatContext $formatContext = this.getFormatContext();
        result = result * 59 + ($formatContext == null ? 43 : $formatContext.hashCode());
        result = result * 59 + this.getBitsPerPixel();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        result = result * 59 + this.getAudioStream();
        result = result * 59 + this.getGopSize();
        long $videoQuality = Double.doubleToLongBits(this.getVideoQuality());
        result = result * 59 + (int)($videoQuality >>> 32 ^ $videoQuality);
        long $audioQuality = Double.doubleToLongBits(this.getAudioQuality());
        result = result * 59 + (int)($audioQuality >>> 32 ^ $audioQuality);
        Preset $preset = this.getPreset();
        result = result * 59 + ($preset == null ? 43 : ((Object)((Object)$preset)).hashCode());
        return result;
    }

    public String toString() {
        return "VideoParameters(width=" + this.getWidth() + ", height=" + this.getHeight() + ", videoCodec=" + this.getVideoCodec() + ", audioCodec=" + this.getAudioCodec() + ", format=" + this.getFormat() + ", sampleRate=" + this.getSampleRate() + ", frameRate=" + this.getFrameRate() + ", videoBitrate=" + this.getVideoBitrate() + ", audioBitrate=" + this.getAudioBitrate() + ", pixelFormat=" + this.getPixelFormat() + ", audioChannels=" + this.getAudioChannels() + ", videoLengthTime=" + this.getVideoLengthTime() + ", lengthInFrames=" + this.getLengthInFrames() + ", lengthInAudioFrames=" + this.getLengthInAudioFrames() + ", videoStream=" + this.getVideoStream() + ", videoOptions=" + this.getVideoOptions() + ", videoCodecName=" + this.getVideoCodecName() + ", metadata=" + this.getMetadata() + ", timeout=" + this.getTimeout() + ", sensorPattern=" + this.getSensorPattern() + ", sampleMode=" + this.getSampleMode() + ", aspectRatio=" + this.getAspectRatio() + ", numBuffers=" + this.getNumBuffers() + ", maxDelay=" + this.getMaxDelay() + ", imageScalingFlags=" + this.getImageScalingFlags() + ", gamma=" + this.getGamma() + ", formatContext=" + this.getFormatContext() + ", bitsPerPixel=" + this.getBitsPerPixel() + ", timestamp=" + this.getTimestamp() + ", audioStream=" + this.getAudioStream() + ", gopSize=" + this.getGopSize() + ", videoQuality=" + this.getVideoQuality() + ", audioQuality=" + this.getAudioQuality() + ", preset=" + (Object)((Object)this.getPreset()) + ")";
    }

    public static class VideoParametersBuilder {
        private int width;
        private int height;
        private int videoCodec;
        private int audioCodec;
        private String format;
        private int sampleRate;
        private double frameRate;
        private int videoBitrate;
        private int audioBitrate;
        private int pixelFormat;
        private int audioChannels;
        private long videoLengthTime;
        private int lengthInFrames;
        private int lengthInAudioFrames;
        private int videoStream;
        private Map<String, String> videoOptions;
        private String videoCodecName;
        private Map<String, String> metadata;
        private int timeout;
        private long sensorPattern;
        private FrameGrabber.SampleMode sampleMode;
        private double aspectRatio;
        private double numBuffers;
        private int maxDelay;
        private int imageScalingFlags;
        private double gamma;
        private AVFormatContext formatContext;
        private int bitsPerPixel;
        private long timestamp;
        private int audioStream;
        private int gopSize;
        private double videoQuality;
        private double audioQuality;
        private Preset preset;

        VideoParametersBuilder() {
        }

        public VideoParametersBuilder width(int width) {
            this.width = width;
            return this;
        }

        public VideoParametersBuilder height(int height) {
            this.height = height;
            return this;
        }

        public VideoParametersBuilder videoCodec(int videoCodec) {
            this.videoCodec = videoCodec;
            return this;
        }

        public VideoParametersBuilder audioCodec(int audioCodec) {
            this.audioCodec = audioCodec;
            return this;
        }

        public VideoParametersBuilder format(String format) {
            this.format = format;
            return this;
        }

        public VideoParametersBuilder sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public VideoParametersBuilder frameRate(double frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public VideoParametersBuilder videoBitrate(int videoBitrate) {
            this.videoBitrate = videoBitrate;
            return this;
        }

        public VideoParametersBuilder audioBitrate(int audioBitrate) {
            this.audioBitrate = audioBitrate;
            return this;
        }

        public VideoParametersBuilder pixelFormat(int pixelFormat) {
            this.pixelFormat = pixelFormat;
            return this;
        }

        public VideoParametersBuilder audioChannels(int audioChannels) {
            this.audioChannels = audioChannels;
            return this;
        }

        public VideoParametersBuilder videoLengthTime(long videoLengthTime) {
            this.videoLengthTime = videoLengthTime;
            return this;
        }

        public VideoParametersBuilder lengthInFrames(int lengthInFrames) {
            this.lengthInFrames = lengthInFrames;
            return this;
        }

        public VideoParametersBuilder lengthInAudioFrames(int lengthInAudioFrames) {
            this.lengthInAudioFrames = lengthInAudioFrames;
            return this;
        }

        public VideoParametersBuilder videoStream(int videoStream) {
            this.videoStream = videoStream;
            return this;
        }

        public VideoParametersBuilder videoOptions(Map<String, String> videoOptions) {
            this.videoOptions = videoOptions;
            return this;
        }

        public VideoParametersBuilder videoCodecName(String videoCodecName) {
            this.videoCodecName = videoCodecName;
            return this;
        }

        public VideoParametersBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public VideoParametersBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public VideoParametersBuilder sensorPattern(long sensorPattern) {
            this.sensorPattern = sensorPattern;
            return this;
        }

        public VideoParametersBuilder sampleMode(FrameGrabber.SampleMode sampleMode) {
            this.sampleMode = sampleMode;
            return this;
        }

        public VideoParametersBuilder aspectRatio(double aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public VideoParametersBuilder numBuffers(double numBuffers) {
            this.numBuffers = numBuffers;
            return this;
        }

        public VideoParametersBuilder maxDelay(int maxDelay) {
            this.maxDelay = maxDelay;
            return this;
        }

        public VideoParametersBuilder imageScalingFlags(int imageScalingFlags) {
            this.imageScalingFlags = imageScalingFlags;
            return this;
        }

        public VideoParametersBuilder gamma(double gamma) {
            this.gamma = gamma;
            return this;
        }

        public VideoParametersBuilder formatContext(AVFormatContext formatContext) {
            this.formatContext = formatContext;
            return this;
        }

        public VideoParametersBuilder bitsPerPixel(int bitsPerPixel) {
            this.bitsPerPixel = bitsPerPixel;
            return this;
        }

        public VideoParametersBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public VideoParametersBuilder audioStream(int audioStream) {
            this.audioStream = audioStream;
            return this;
        }

        public VideoParametersBuilder gopSize(int gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public VideoParametersBuilder videoQuality(double videoQuality) {
            this.videoQuality = videoQuality;
            return this;
        }

        public VideoParametersBuilder audioQuality(double audioQuality) {
            this.audioQuality = audioQuality;
            return this;
        }

        public VideoParametersBuilder preset(Preset preset) {
            this.preset = preset;
            return this;
        }

        public VideoParameters build() {
            return new VideoParameters(this.width, this.height, this.videoCodec, this.audioCodec, this.format, this.sampleRate, this.frameRate, this.videoBitrate, this.audioBitrate, this.pixelFormat, this.audioChannels, this.videoLengthTime, this.lengthInFrames, this.lengthInAudioFrames, this.videoStream, this.videoOptions, this.videoCodecName, this.metadata, this.timeout, this.sensorPattern, this.sampleMode, this.aspectRatio, this.numBuffers, this.maxDelay, this.imageScalingFlags, this.gamma, this.formatContext, this.bitsPerPixel, this.timestamp, this.audioStream, this.gopSize, this.videoQuality, this.audioQuality, this.preset);
        }

        public String toString() {
            return "VideoParameters.VideoParametersBuilder(width=" + this.width + ", height=" + this.height + ", videoCodec=" + this.videoCodec + ", audioCodec=" + this.audioCodec + ", format=" + this.format + ", sampleRate=" + this.sampleRate + ", frameRate=" + this.frameRate + ", videoBitrate=" + this.videoBitrate + ", audioBitrate=" + this.audioBitrate + ", pixelFormat=" + this.pixelFormat + ", audioChannels=" + this.audioChannels + ", videoLengthTime=" + this.videoLengthTime + ", lengthInFrames=" + this.lengthInFrames + ", lengthInAudioFrames=" + this.lengthInAudioFrames + ", videoStream=" + this.videoStream + ", videoOptions=" + this.videoOptions + ", videoCodecName=" + this.videoCodecName + ", metadata=" + this.metadata + ", timeout=" + this.timeout + ", sensorPattern=" + this.sensorPattern + ", sampleMode=" + this.sampleMode + ", aspectRatio=" + this.aspectRatio + ", numBuffers=" + this.numBuffers + ", maxDelay=" + this.maxDelay + ", imageScalingFlags=" + this.imageScalingFlags + ", gamma=" + this.gamma + ", formatContext=" + this.formatContext + ", bitsPerPixel=" + this.bitsPerPixel + ", timestamp=" + this.timestamp + ", audioStream=" + this.audioStream + ", gopSize=" + this.gopSize + ", videoQuality=" + this.videoQuality + ", audioQuality=" + this.audioQuality + ", preset=" + (Object)((Object)this.preset) + ")";
        }
    }
}

