/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.video.format;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUnit;
import cn.novelweb.video.format.callback.ProgressCallback;
import cn.novelweb.video.pojo.Preset;
import cn.novelweb.video.pojo.VideoParameters;
import java.io.File;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.FrameRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatConversion {
    private static final Logger log = LoggerFactory.getLogger(FormatConversion.class);

    public static VideoParameters getVideoParameters(String filePath) {
        File file = new File(filePath);
        return FormatConversion.getVideoParameters(file);
    }

    public static VideoParameters getVideoParameters(File file) {
        if (!file.isFile()) {
            log.error("\u5b83\u4e0d\u662f\u4e00\u4e2a\u6807\u51c6\u7684\u6587\u4ef6");
            return null;
        }
        FFmpegFrameGrabber fFmpegFrameGrabber = new FFmpegFrameGrabber(file);
        try {
            fFmpegFrameGrabber.start();
            VideoParameters videoParameters = VideoParameters.builder().width(fFmpegFrameGrabber.getImageWidth()).height(fFmpegFrameGrabber.getImageHeight()).videoCodec(fFmpegFrameGrabber.getVideoCodec()).audioCodec(fFmpegFrameGrabber.getAudioCodec()).format(fFmpegFrameGrabber.getFormat()).sampleRate(fFmpegFrameGrabber.getSampleRate()).frameRate(fFmpegFrameGrabber.getFrameRate()).videoBitrate(fFmpegFrameGrabber.getVideoBitrate()).audioBitrate(fFmpegFrameGrabber.getAudioBitrate()).pixelFormat(fFmpegFrameGrabber.getPixelFormat()).audioChannels(fFmpegFrameGrabber.getAudioChannels()).videoLengthTime(fFmpegFrameGrabber.getLengthInTime() / 1000000L).lengthInFrames(fFmpegFrameGrabber.getLengthInFrames()).lengthInAudioFrames(fFmpegFrameGrabber.getLengthInAudioFrames()).videoStream(fFmpegFrameGrabber.getVideoStream()).videoOptions(fFmpegFrameGrabber.getVideoOptions()).videoCodecName(fFmpegFrameGrabber.getVideoCodecName()).metadata(fFmpegFrameGrabber.getMetadata()).timeout(fFmpegFrameGrabber.getTimeout()).sensorPattern(fFmpegFrameGrabber.getSensorPattern()).sampleMode(fFmpegFrameGrabber.getSampleMode()).aspectRatio(fFmpegFrameGrabber.getAspectRatio()).numBuffers(fFmpegFrameGrabber.getNumBuffers()).maxDelay(fFmpegFrameGrabber.getMaxDelay()).imageScalingFlags(fFmpegFrameGrabber.getImageScalingFlags()).gamma(fFmpegFrameGrabber.getGamma()).formatContext(fFmpegFrameGrabber.getFormatContext()).bitsPerPixel(fFmpegFrameGrabber.getBitsPerPixel()).timestamp(fFmpegFrameGrabber.getTimestamp()).audioStream(fFmpegFrameGrabber.getAudioStream()).gopSize((int)fFmpegFrameGrabber.getFrameRate() * 2).videoQuality(-1.0).audioQuality(-1.0).preset(Preset.slow).build();
            fFmpegFrameGrabber.stop();
            return videoParameters;
        }
        catch (FrameGrabber.Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void converter(File input, File output, VideoParameters parameters, ProgressCallback callback) {
        if (!input.isFile()) {
            log.error("\u5b83\u4e0d\u662f\u4e00\u4e2a\u6807\u51c6\u7684\u6587\u4ef6");
            return;
        }
        if (output.isFile()) {
            log.error("\u9700\u8981\u8f93\u51fa\u7684\u6587\u4ef6\u5df2\u5b58\u5728");
            return;
        }
        try {
            Frame capturedFrame;
            FFmpegFrameGrabber grabber = new FFmpegFrameGrabber(input);
            grabber.start();
            FFmpegFrameRecorder recorder = new FFmpegFrameRecorder(output, parameters.getWidth(), parameters.getHeight());
            recorder.setVideoCodec(parameters.getVideoCodec());
            recorder.setAudioCodec(parameters.getAudioCodec());
            recorder.setFormat(parameters.getFormat());
            recorder.setSampleRate(parameters.getSampleRate());
            recorder.setFrameRate(parameters.getFrameRate());
            recorder.setVideoBitrate(parameters.getVideoBitrate());
            recorder.setAudioChannels(parameters.getAudioChannels());
            recorder.setGopSize(parameters.getGopSize());
            recorder.setVideoQuality(parameters.getVideoQuality());
            recorder.setAudioQuality(parameters.getAudioQuality());
            recorder.setVideoOption("preset", parameters.getPreset().toString());
            if (parameters.getAudioBitrate() <= 0) {
                recorder.setAudioBitrate(192000);
            } else {
                recorder.setAudioBitrate(parameters.getAudioBitrate());
            }
            recorder.start();
            long nextSecondTimestamp = System.currentTimeMillis() + DateUnit.SECOND.getMillis();
            double minPercentage = 0.001;
            while ((capturedFrame = grabber.grabFrame()) != null) {
                if (System.currentTimeMillis() >= nextSecondTimestamp) {
                    double lengthInTime;
                    double timestamp = (Double)Convert.convert(Double.TYPE, (Object)grabber.getTimestamp());
                    double resultValue = timestamp / (lengthInTime = ((Double)Convert.convert(Double.TYPE, (Object)grabber.getLengthInTime())).doubleValue());
                    if (resultValue < minPercentage) {
                        resultValue = 0.0;
                    }
                    if (callback != null) {
                        callback.progress(resultValue);
                    }
                    nextSecondTimestamp = System.currentTimeMillis() + DateUnit.SECOND.getMillis();
                }
                recorder.setTimestamp(grabber.getTimestamp());
                recorder.record(capturedFrame);
                capturedFrame.clone();
            }
            grabber.stop();
            grabber.release();
            grabber.close();
            recorder.stop();
            recorder.release();
            recorder.close();
            if (callback != null) {
                callback.progress(1.0);
            }
            System.gc();
        }
        catch (FrameGrabber.Exception e) {
            e.printStackTrace();
            log.error("\u83b7\u53d6\u89c6\u9891\u6e90\u5f02\u5e38:" + e.getMessage());
        }
        catch (FrameRecorder.Exception e) {
            e.printStackTrace();
            log.error("\u6784\u5efa\u6d41\u5a92\u4f53\u8f93\u51fa\u5730\u5740\u5f02\u5e38:" + e.getMessage());
        }
    }

    public static void converterToMp4(String inputPath, String outputPath, ProgressCallback callback) {
        FormatConversion.converterToMp4(new File(inputPath), new File(outputPath), callback);
    }

    public static void converterToMp4(File input, File output, ProgressCallback callback) {
        VideoParameters parameters = FormatConversion.getVideoParameters(input);
        if (parameters == null) {
            return;
        }
        parameters.setVideoCodec(27);
        parameters.setFormat("mp4");
        parameters.setAudioCodec(86018);
        FormatConversion.converter(input, output, parameters, callback);
    }
}

