/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.video.edit;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.novelweb.tool.date.DateUtils;
import cn.novelweb.video.command.CommandLineOperations;
import cn.novelweb.video.command.assemble.CommandBuilderFactory;
import cn.novelweb.video.edit.WatermarkLocation;
import cn.novelweb.video.format.callback.ProgressCallback;
import cn.novelweb.video.pojo.CommandTask;
import cn.novelweb.video.pojo.ProgramConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.lang.StringUtils;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoEditing {
    private static final Logger log = LoggerFactory.getLogger(VideoEditing.class);

    public static void init(ProgramConfig programConfig) {
        CommandLineOperations.init(programConfig);
    }

    public static void addSubtitles(String subtitles, String input, String output, ProgressCallback callback) {
        String taskId = System.currentTimeMillis() + RandomUtil.randomNumbers((int)10);
        CommandLineOperations.start(taskId, CommandBuilderFactory.create().add("-i", input).add("-vf", "subtitles=" + subtitles).add("-movflags", "faststart").add("-y").add(output));
        VideoEditing.getProgress(taskId, input, callback);
    }

    public static void converterToMp4(String input, String output, ProgressCallback callback) {
        String taskId = System.currentTimeMillis() + RandomUtil.randomNumbers((int)10);
        CommandLineOperations.start(taskId, CommandBuilderFactory.create().add("-i", input).add("-vcodec", "h264").add("-y").add("-movflags", "faststart").add(output));
        VideoEditing.getProgress(taskId, input, callback);
    }

    public static void addSubtitlesToMp4(String subtitles, String input, String output, ProgressCallback callback) {
        output = StrUtil.appendIfMissing((CharSequence)output, (CharSequence)".mp4", (CharSequence[])new CharSequence[]{".mp4"});
        String taskId = System.currentTimeMillis() + RandomUtil.randomNumbers((int)10);
        CommandLineOperations.start(taskId, CommandBuilderFactory.create().add("-i", input).add("-vf", "subtitles=" + subtitles).add("-vcodec", "h264").add("-y").add(output));
        VideoEditing.getProgress(taskId, input, callback);
    }

    public static void addWatermark(String watermark, WatermarkLocation location, String input, String output, ProgressCallback callback) {
        String taskId = System.currentTimeMillis() + RandomUtil.randomNumbers((int)10);
        CommandLineOperations.start(taskId, CommandBuilderFactory.create().add("-i", input).add("-i", watermark).add("-filter_complex", WatermarkLocation.map.get((Object)location)).add("-codec copy -y").add(output));
        VideoEditing.getProgress(taskId, input, callback);
    }

    public static void clipVideo(String startTime, String duration, String input, String output, ProgressCallback callback) {
        String taskId = System.currentTimeMillis() + RandomUtil.randomNumbers((int)10);
        CommandLineOperations.start(taskId, CommandBuilderFactory.create().add("-i", input).add("-ss", startTime).add("-t", duration).add("-codec copy -y").add(output));
        VideoEditing.getProgress(taskId, input, callback);
    }

    public static void separation(String input, String videoStream, String audioStream, ProgressCallback videoCallback, ProgressCallback audioCallback) {
        String taskId;
        if (StringUtils.isNotBlank((String)videoStream)) {
            taskId = System.currentTimeMillis() + RandomUtil.randomNumbers((int)10);
            CommandLineOperations.start(taskId, CommandBuilderFactory.create().add("-i", input).add("-vcodec copy -an").add(videoStream));
            VideoEditing.getProgress(taskId, input, videoCallback);
        }
        if (StringUtils.isNotBlank((String)audioStream)) {
            taskId = System.currentTimeMillis() + RandomUtil.randomNumbers((int)10);
            CommandLineOperations.start(taskId, CommandBuilderFactory.create().add("-i", input).add("-vcodec copy -vn").add(audioStream));
            VideoEditing.getProgress(taskId, input, audioCallback);
        }
    }

    public static void separationVideoStream(String input, String videoStream, ProgressCallback callback) {
        VideoEditing.separation(input, videoStream, null, callback, null);
    }

    public static void separationAudioStream(String input, String audioStream, ProgressCallback callback) {
        VideoEditing.separation(input, null, audioStream, null, callback);
    }

    public static void grabbingFrameToJpg(String input, String output, double frequency, int quality, ProgressCallback callback) {
        output = StrUtil.appendIfMissing((CharSequence)output, (CharSequence)"/", (CharSequence[])new CharSequence[]{"/"});
        String taskId = System.currentTimeMillis() + RandomUtil.randomNumbers((int)10);
        CommandLineOperations.start(taskId, CommandBuilderFactory.create().add("-i", input).add("-r", String.valueOf(frequency)).add("-q:v", String.valueOf(quality)).add("-f", "image2").add(output + "%01d.jpeg"));
        VideoEditing.getProgress(taskId, input, callback);
    }

    public static void grabbingFrameToJpg(String input, String output, String startTime, String duration, double frequency, int quality, ProgressCallback callback) {
        output = StrUtil.appendIfMissing((CharSequence)output, (CharSequence)"/", (CharSequence[])new CharSequence[]{"/"});
        String taskId = System.currentTimeMillis() + RandomUtil.randomNumbers((int)10);
        CommandLineOperations.start(taskId, CommandBuilderFactory.create().add("-i", input).add("-ss", startTime).add("-t", duration).add("-r", String.valueOf(frequency)).add("-q:v", String.valueOf(quality)).add("-f", "image2").add(output + "%01d.jpeg"));
        VideoEditing.getProgress(taskId, input, callback);
    }

    public static void grabbingFrameToGif(String input, String output, String resolutionRatio, String startTime, String duration, ProgressCallback callback) {
        String taskId = System.currentTimeMillis() + RandomUtil.randomNumbers((int)10);
        CommandLineOperations.start(taskId, CommandBuilderFactory.create().add("-i", input).add("-ss", startTime).add("-t", duration).add("-s", resolutionRatio).add(output));
        VideoEditing.getProgress(taskId, input, callback);
    }

    public static void deleteSoundTrack(String input, String output, int needKeep, ProgressCallback callback) {
        String taskId = System.currentTimeMillis() + RandomUtil.randomNumbers((int)10);
        CommandLineOperations.start(taskId, CommandBuilderFactory.create().add("-i", input).add("-map", "0:0").add("-map", "0:" + needKeep).add("-vcodec", "copy").add("-acodec", "copy").add(output));
        VideoEditing.getProgress(taskId, input, callback);
    }

    public static void deleteSoundTrackToMp4(String input, String output, int needKeep, ProgressCallback callback) {
        String taskId = System.currentTimeMillis() + RandomUtil.randomNumbers((int)10);
        CommandLineOperations.start(taskId, CommandBuilderFactory.create().add("-i", input).add("-map", "0:0").add("-map", "0:" + needKeep).add("-vcodec", "h264").add("-vcodec", "copy").add("-acodec", "copy").add("-y").add(output));
        VideoEditing.getProgress(taskId, input, callback);
    }

    public static void getProgress(String taskId, String input, ProgressCallback callback) {
        CommandTask commandTask = CommandLineOperations.get(taskId);
        if (commandTask == null) {
            log.error("\u4efb\u52a1id: {} \u67e5\u8be2\u5931\u8d25", (Object)taskId);
            return;
        }
        FFmpegFrameGrabber fFmpegFrameGrabber = new FFmpegFrameGrabber(input);
        try {
            String message;
            fFmpegFrameGrabber.start();
            long duration = fFmpegFrameGrabber.getLengthInTime() / 1000L;
            fFmpegFrameGrabber.stop();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(commandTask.getProcess().getErrorStream()));
            double minPercentage = 0.001;
            if (callback != null) {
                callback.progress(0.0);
            }
            while ((message = bufferedReader.readLine()) != null) {
                double toTalCompleted;
                String timeStamp = ReUtil.get((String)"time=.*? ", (CharSequence)message, (int)0);
                if (!StringUtils.isNotBlank((String)timeStamp) || duration <= 0L) continue;
                double progressCompleted = (Double)Convert.convert(Double.TYPE, (Object)DateUtils.getTimeConversion((String)(timeStamp = ReUtil.delAll((String)"time=", (CharSequence)timeStamp.trim()))));
                double resultValue = progressCompleted / (toTalCompleted = ((Double)Convert.convert(Double.TYPE, (Object)duration)).doubleValue());
                if (resultValue < minPercentage) {
                    resultValue = 0.0;
                }
                if (callback == null) continue;
                callback.progress(resultValue);
            }
            if (callback != null) {
                callback.progress(1.0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

