/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.video.command.handler;

import cn.novelweb.tool.upload.fastdfs.utils.Log;
import cn.novelweb.video.command.handler.KeepAliveHandler;
import cn.novelweb.video.command.handler.OutHandlerMethod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class OutHandler
extends Thread {
    private volatile boolean desStatus = true;
    private BufferedReader bufferedReader;
    private String taskId;
    private OutHandlerMethod outHandlerMethod;

    public static OutHandler create(InputStream inputStream, String taskId, OutHandlerMethod outHandlerMethod) {
        return OutHandler.create(inputStream, taskId, outHandlerMethod, true);
    }

    public static OutHandler create(InputStream inputStream, String taskId, OutHandlerMethod outHandlerMethod, boolean start) {
        OutHandler out = new OutHandler(inputStream, taskId, outHandlerMethod);
        if (start) {
            out.start();
        }
        return out;
    }

    public OutHandler(InputStream inputStream, String taskId, OutHandlerMethod outHandlerMethod) {
        this.bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.taskId = taskId;
        this.outHandlerMethod = outHandlerMethod;
    }

    @Override
    public void run() {
        if (this.isInterrupted()) {
            Log.debug((String)"\u4efb\u52a1id:{},\u7ebf\u7a0b\u5df2\u5173\u95ed", (Object)this.taskId);
            return;
        }
        try {
            String message;
            Log.debug((String)"\u4efb\u52a1id:{},\u5f00\u59cb\u6267\u884c\u4efb\u52a1.", (Object)this.taskId);
            while (this.desStatus && (message = this.bufferedReader.readLine()) != null) {
                this.outHandlerMethod.parsing(this.taskId, message);
                if (!this.outHandlerMethod.isBroken()) continue;
                Log.debug((String)"\u4efb\u52a1id:{},\u68c0\u6d4b\u5230\u4e2d\u65ad,\u63d0\u4ea4\u91cd\u542f\u4efb\u52a1\u7ed9\u4fdd\u6d3b\u5904\u7406\u5668.", (Object)this.taskId);
                KeepAliveHandler.add(this.taskId);
            }
        }
        catch (IOException e) {
            Log.debug((String)"\u4efb\u52a1id:{},\u53d1\u751f\u5185\u90e8\u5f02\u5e38\u9519\u8bef,\u7ebf\u7a0b\u6807\u8bb0\u505c\u6b62\u72b6\u6001", (Object)this.taskId);
            this.interrupt();
        }
    }

    public static OutHandlerBuilder builder() {
        return new OutHandlerBuilder();
    }

    public OutHandler() {
    }

    public OutHandler(boolean desStatus, BufferedReader bufferedReader, String taskId, OutHandlerMethod outHandlerMethod) {
        this.desStatus = desStatus;
        this.bufferedReader = bufferedReader;
        this.taskId = taskId;
        this.outHandlerMethod = outHandlerMethod;
    }

    public void setDesStatus(boolean desStatus) {
        this.desStatus = desStatus;
    }

    public void setBufferedReader(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setOutHandlerMethod(OutHandlerMethod outHandlerMethod) {
        this.outHandlerMethod = outHandlerMethod;
    }

    public boolean isDesStatus() {
        return this.desStatus;
    }

    public BufferedReader getBufferedReader() {
        return this.bufferedReader;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public OutHandlerMethod getOutHandlerMethod() {
        return this.outHandlerMethod;
    }

    @Override
    public String toString() {
        return "OutHandler(super=" + super.toString() + ", desStatus=" + this.isDesStatus() + ", bufferedReader=" + this.getBufferedReader() + ", taskId=" + this.getTaskId() + ", outHandlerMethod=" + this.getOutHandlerMethod() + ")";
    }

    public static class OutHandlerBuilder {
        private boolean desStatus;
        private BufferedReader bufferedReader;
        private String taskId;
        private OutHandlerMethod outHandlerMethod;

        OutHandlerBuilder() {
        }

        public OutHandlerBuilder desStatus(boolean desStatus) {
            this.desStatus = desStatus;
            return this;
        }

        public OutHandlerBuilder bufferedReader(BufferedReader bufferedReader) {
            this.bufferedReader = bufferedReader;
            return this;
        }

        public OutHandlerBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public OutHandlerBuilder outHandlerMethod(OutHandlerMethod outHandlerMethod) {
            this.outHandlerMethod = outHandlerMethod;
            return this;
        }

        public OutHandler build() {
            return new OutHandler(this.desStatus, this.bufferedReader, this.taskId, this.outHandlerMethod);
        }

        public String toString() {
            return "OutHandler.OutHandlerBuilder(desStatus=" + this.desStatus + ", bufferedReader=" + this.bufferedReader + ", taskId=" + this.taskId + ", outHandlerMethod=" + this.outHandlerMethod + ")";
        }
    }
}

