/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.video.command;

import cn.hutool.core.map.MapUtil;
import cn.novelweb.video.command.assemble.CommandBuilder;
import cn.novelweb.video.command.handler.CommandHandler;
import cn.novelweb.video.command.handler.CommandHandlerImpl;
import cn.novelweb.video.pojo.CommandTask;
import cn.novelweb.video.pojo.ProgramConfig;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineOperations {
    private static final Logger log = LoggerFactory.getLogger(CommandLineOperations.class);
    private static CommandHandler commandHandler;
    private static boolean isSuccessInit;

    public static void init(ProgramConfig programConfig) {
        if (programConfig == null) {
            log.error("\u5165\u53e3\u53c2\u6570:programConfig\u4e3anull");
            return;
        }
        CommandHandlerImpl.programConfig = programConfig;
        commandHandler = new CommandHandlerImpl();
        isSuccessInit = true;
    }

    public static String start(String taskId, String command) {
        if (!isSuccessInit) {
            log.error("\u8bf7\u5148\u8c03\u7528.init()\u65b9\u6cd5\u521d\u59cb\u5316\u914d\u7f6e");
            return null;
        }
        if (StringUtils.isBlank((String)taskId) && StringUtils.isNotBlank((String)command)) {
            log.error("\u53c2\u6570\u503c\u4e3a\u7a7a");
            return null;
        }
        return commandHandler.start(taskId, command);
    }

    public static String start(String taskId, String command, boolean hasPath) {
        if (!isSuccessInit) {
            log.error("\u8bf7\u5148\u8c03\u7528.init()\u65b9\u6cd5\u521d\u59cb\u5316\u914d\u7f6e");
            return null;
        }
        if (StringUtils.isBlank((String)taskId) && StringUtils.isNotBlank((String)command)) {
            log.error("\u53c2\u6570\u503c\u4e3a\u7a7a");
            return null;
        }
        return commandHandler.start(taskId, command, hasPath);
    }

    public static String start(String taskId, CommandBuilder commandBuilder) {
        if (!isSuccessInit) {
            log.error("\u8bf7\u5148\u8c03\u7528.init()\u65b9\u6cd5\u521d\u59cb\u5316\u914d\u7f6e");
            return null;
        }
        if (StringUtils.isBlank((String)taskId) && commandBuilder == null) {
            log.error("\u53c2\u6570\u503c\u4e3a\u7a7a");
            return null;
        }
        return commandHandler.start(taskId, commandBuilder);
    }

    public static String start(Map<String, String> map) {
        if (!isSuccessInit) {
            log.error("\u8bf7\u5148\u8c03\u7528.init()\u65b9\u6cd5\u521d\u59cb\u5316\u914d\u7f6e");
            return null;
        }
        if (MapUtil.isEmpty(map)) {
            log.error("\u53c2\u6570map\u503c\u4e3a\u7a7a");
            return null;
        }
        return commandHandler.start(map);
    }

    public static boolean stop(String taskId) {
        if (!isSuccessInit) {
            log.error("\u8bf7\u5148\u8c03\u7528.init()\u65b9\u6cd5\u521d\u59cb\u5316\u914d\u7f6e");
            return false;
        }
        if (StringUtils.isBlank((String)taskId)) {
            log.error("\u53c2\u6570taskId\u503c\u4e3a\u7a7a");
            return false;
        }
        return commandHandler.stop(taskId);
    }

    public static int stopAll() {
        if (!isSuccessInit) {
            log.error("\u8bf7\u5148\u8c03\u7528.init()\u65b9\u6cd5\u521d\u59cb\u5316\u914d\u7f6e");
            return -1;
        }
        return commandHandler.stopAll();
    }

    public static CommandTask get(String taskId) {
        if (!isSuccessInit) {
            log.error("\u8bf7\u5148\u8c03\u7528.init()\u65b9\u6cd5\u521d\u59cb\u5316\u914d\u7f6e");
            return null;
        }
        if (StringUtils.isBlank((String)taskId)) {
            log.error("\u53c2\u6570taskId\u503c\u4e3a\u7a7a");
            return null;
        }
        return commandHandler.get(taskId);
    }

    public static Collection<CommandTask> getAll() {
        if (!isSuccessInit) {
            log.error("\u8bf7\u5148\u8c03\u7528.init()\u65b9\u6cd5\u521d\u59cb\u5316\u914d\u7f6e");
            return null;
        }
        return commandHandler.getAll();
    }

    public static void destroy() {
        if (!isSuccessInit) {
            log.error("\u8bf7\u5148\u8c03\u7528.init()\u65b9\u6cd5\u521d\u59cb\u5316\u914d\u7f6e");
            return;
        }
        commandHandler.destroy();
    }

    static {
        isSuccessInit = false;
    }
}

