/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.ip;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Singleton;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.StrUtil;
import cn.novelweb.ip.Region;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.io.IOUtils;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.DbSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return hostName;
        }
    }

    public static InetAddress getLocalhost() {
        return NetUtil.getLocalhost();
    }

    public static String getLocalhostStr() {
        return NetUtil.getLocalhostStr();
    }

    public static String hideIpPart(String ip) {
        return NetUtil.hideIpPart((String)ip);
    }

    public static boolean isInnerIp(String ip) {
        return NetUtil.isInnerIP((String)ip);
    }

    public static boolean isUsableLocalPort(int port) {
        return NetUtil.isUsableLocalPort((int)port);
    }

    public static boolean isValidPort(int port) {
        return NetUtil.isValidPort((int)port);
    }

    public static Region getIpLocationByMemory(String ip) {
        return IpUtils.getIpLocation(ip, "memorySearch");
    }

    public static Region getIpLocationByBtree(String ip) {
        return IpUtils.getIpLocation(ip, "btreeSearch");
    }

    public static Region getIpLocationByBinary(String ip) {
        return IpUtils.getIpLocation(ip, "binarySearch");
    }

    private static synchronized Region getIpLocation(String ip, String algorithm) {
        String intranetIp = "\u5185\u7f51IP";
        if (StrUtil.isBlank((CharSequence)ip)) {
            log.info("The IP address detected is empty...");
            return new Region(intranetIp, intranetIp, intranetIp, intranetIp);
        }
        if (IpUtils.isInnerIp(ip)) {
            return new Region(intranetIp, intranetIp, intranetIp, intranetIp);
        }
        try {
            DbConfig config = (DbConfig)Singleton.get(DbConfig.class, (Object[])new Object[0]);
            File tempFile = FileUtil.touch((File)((File)Singleton.get(File.class, (Object[])new Object[]{"ip2region.db"})));
            InputStream inputStream = IpUtils.class.getClassLoader().getResourceAsStream("data/ip2region.db");
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                if (inputStream != null) {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)out);
                }
            }
            DbSearcher dbSearcher = (DbSearcher)Singleton.get(DbSearcher.class, (Object[])new Object[]{config, tempFile.getPath()});
            Method method = dbSearcher.getClass().getMethod(algorithm, String.class);
            DataBlock dataBlock = (DataBlock)method.invoke((Object)dbSearcher, ip);
            if (dataBlock != null && StrUtil.isNotBlank((CharSequence)dataBlock.getRegion())) {
                String[] ipData = dataBlock.getRegion().split("\\|");
                return Region.builder().country(ipData[0]).province(ipData[2]).city(ipData[3]).isp(ipData[4]).build();
            }
            return new Region(intranetIp, intranetIp, intranetIp, intranetIp);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Region(intranetIp, intranetIp, intranetIp, intranetIp);
        }
    }
}

