/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.protocol;

import cn.novelweb.tool.upload.fastdfs.protocol.ProtocolHead;
import cn.novelweb.tool.upload.fastdfs.utils.FastDfsParamMapperUtils;
import cn.novelweb.tool.upload.fastdfs.utils.ReflectionsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public abstract class BaseResponse<T> {
    private ProtocolHead head;
    private final Class<T> genericType = ReflectionsUtils.getClassGenricType(this.getClass());

    protected long getContentLength() {
        return this.head.getContentLength();
    }

    T decode(ProtocolHead head, InputStream in, Charset charset) throws IOException {
        this.head = head;
        return this.decodeContent(in, charset);
    }

    public T decodeContent(InputStream in, Charset charset) throws IOException {
        if (this.getContentLength() > 0L) {
            byte[] bytes = new byte[(int)this.getContentLength()];
            int contentSize = in.read(bytes);
            if ((long)contentSize != this.getContentLength()) {
                throw new IOException("\u8bfb\u53d6\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e0e\u534f\u8bae\u957f\u5ea6\u4e0d\u7b26");
            }
            return FastDfsParamMapperUtils.map(bytes, this.genericType, charset);
        }
        return null;
    }
}

