/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.pool;

import cn.novelweb.tool.upload.fastdfs.conn.Connection;
import cn.novelweb.tool.upload.fastdfs.conn.SocketConnection;
import cn.novelweb.tool.upload.fastdfs.utils.Log;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnectionFactory
extends BaseKeyedPooledObjectFactory<InetSocketAddress, Connection> {
    private static final Logger log = LoggerFactory.getLogger(PooledConnectionFactory.class);
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private String charsetName = "UTF-8";
    private int soTimeout;
    private int connectTimeout;
    private Charset charset;

    public PooledConnectionFactory(int soTimeout, int connectTimeout, Charset charset) {
        this.soTimeout = soTimeout;
        this.connectTimeout = connectTimeout;
        this.charset = charset;
    }

    public PooledConnectionFactory(int soTimeout, int connectTimeout) {
        this(soTimeout, connectTimeout, null);
    }

    public Connection create(InetSocketAddress address) throws Exception {
        if (null == this.charset) {
            this.charset = Charset.forName(this.charsetName);
        }
        SocketConnection connection = new SocketConnection(address, this.soTimeout, this.connectTimeout, this.charset);
        Log.debug("\u65b0\u5efa\u8fde\u63a5[{}]", (Object)address);
        return connection;
    }

    public PooledObject<Connection> wrap(Connection conn) {
        return new DefaultPooledObject((Object)conn);
    }

    public void destroyObject(InetSocketAddress key, PooledObject<Connection> p) throws Exception {
        ((Connection)p.getObject()).close();
        Log.debug("\u5173\u95ed\u8fde\u63a5[{}]", (Object)key);
    }

    public boolean validateObject(InetSocketAddress key, PooledObject<Connection> p) {
        boolean flag = ((Connection)p.getObject()).isValid();
        Log.debug("\u9a8c\u8bc1\u8fde\u63a5\u662f\u5426\u53ef\u7528[{}],\u9a8c\u8bc1\u7ed3\u679c[{}]", (Object)key, (Object)flag);
        return flag;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }
}

