/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.model;

import cn.novelweb.tool.upload.fastdfs.exception.FastDfsUnsupportedStorePathException;
import cn.novelweb.tool.upload.fastdfs.mapper.DynamicFieldType;
import cn.novelweb.tool.upload.fastdfs.mapper.FastDfsColumn;
import java.io.Serializable;
import org.apache.commons.lang.Validate;

public class StorePath
implements Serializable {
    private static final String SPLIT_GROUP_NAME_AND_FILENAME_SEPARATOR = "/";
    private static final String SPLIT_GROUP_NAME = "group";
    @FastDfsColumn(index=0, max=16)
    private String group;
    @FastDfsColumn(index=1, dynamicField=DynamicFieldType.allRestByte)
    private String path;

    public StorePath() {
    }

    public StorePath(String group, String path) {
        this.group = group;
        this.path = path;
    }

    public String getFullPath() {
        return this.group.concat(SPLIT_GROUP_NAME_AND_FILENAME_SEPARATOR).concat(this.path);
    }

    public static StorePath parseFromUrl(String filePath) {
        Validate.notNull((Object)filePath, (String)"\u89e3\u6790\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        int groupStartPos = StorePath.getGroupStartPos(filePath);
        String groupAndPath = filePath.substring(groupStartPos);
        int pos = groupAndPath.indexOf(SPLIT_GROUP_NAME_AND_FILENAME_SEPARATOR);
        if (pos <= 0 || pos == groupAndPath.length() - 1) {
            throw new FastDfsUnsupportedStorePathException("\u89e3\u6790\u6587\u4ef6\u8def\u5f84\u9519\u8bef,\u6709\u6548\u7684\u8def\u5f84\u6837\u5f0f\u4e3a(group/path) \u800c\u5f53\u524d\u89e3\u6790\u8def\u5f84\u4e3a".concat(filePath));
        }
        String group = groupAndPath.substring(0, pos);
        String path = groupAndPath.substring(pos + 1);
        return new StorePath(group, path);
    }

    private static int getGroupStartPos(String filePath) {
        int pos = filePath.indexOf(SPLIT_GROUP_NAME);
        if (pos == -1) {
            throw new FastDfsUnsupportedStorePathException("\u89e3\u6790\u6587\u4ef6\u8def\u5f84\u9519\u8bef,\u88ab\u89e3\u6790\u8def\u5f84url\u6ca1\u6709group,\u5f53\u524d\u89e3\u6790\u8def\u5f84\u4e3a".concat(filePath));
        }
        return pos;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return "StorePath{group='" + this.group + '\'' + ", path='" + this.path + '\'' + '}';
    }
}

