/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.conn;

import cn.novelweb.tool.upload.fastdfs.conn.CommandExecutor;
import cn.novelweb.tool.upload.fastdfs.conn.Connection;
import cn.novelweb.tool.upload.fastdfs.exception.FastDfsConnectException;
import cn.novelweb.tool.upload.fastdfs.exception.FastDfsException;
import cn.novelweb.tool.upload.fastdfs.pool.ConnectionPool;
import cn.novelweb.tool.upload.fastdfs.pool.TrackerLocator;
import cn.novelweb.tool.upload.fastdfs.protocol.AbstractCommand;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.AbstractStorageCommand;
import cn.novelweb.tool.upload.fastdfs.protocol.tracker.AbstractTrackerCommand;
import cn.novelweb.tool.upload.fastdfs.utils.Log;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommandExecutor
implements CommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultCommandExecutor.class);
    private final TrackerLocator trackerLocator;
    private ConnectionPool pool;

    public DefaultCommandExecutor(String trackerStr, ConnectionPool pool) {
        String[] trackerArray;
        Log.debug("\u521d\u59cb\u5316Tracker Server\u8fde\u63a5 {}", (Object)trackerStr);
        HashSet<String> trackerSet = new HashSet<String>();
        for (String tracker : trackerArray = StringUtils.split((String)trackerStr, (String)",")) {
            if (StringUtils.isBlank((String)tracker)) continue;
            trackerSet.add(tracker.trim());
        }
        if (trackerSet.size() <= 0) {
            throw new RuntimeException("Tracker Server\u670d\u52a1\u5668IP\u5730\u5740\u89e3\u6790\u5931\u8d25:[" + trackerStr + "]");
        }
        this.pool = pool;
        this.trackerLocator = new TrackerLocator(trackerSet);
    }

    public DefaultCommandExecutor(Set<String> trackerSet, ConnectionPool pool) {
        Log.debug("\u521d\u59cb\u5316Tracker Server\u8fde\u63a5 {}", trackerSet);
        this.pool = pool;
        this.trackerLocator = new TrackerLocator(trackerSet);
    }

    @Override
    public <T> T execute(AbstractTrackerCommand<T> command) {
        Connection conn;
        InetSocketAddress address;
        try {
            address = this.trackerLocator.getTrackerAddress();
            conn = this.getConnection(address);
        }
        catch (Throwable e) {
            throw new RuntimeException("\u83b7\u53d6Tracker\u670d\u52a1\u5668\u5730\u5740\u5931\u8d25", e);
        }
        Log.debug("\u83b7\u53d6\u5230Tracker\u8fde\u63a5\u5730\u5740{}", (Object)address);
        return this.executeCmd(address, conn, command);
    }

    @Override
    public <T> T execute(InetSocketAddress address, AbstractStorageCommand<T> command) {
        Connection conn;
        try {
            conn = this.getConnection(address);
        }
        catch (Throwable e) {
            throw new RuntimeException("\u83b7\u53d6Storage\u670d\u52a1\u5668\u5730\u5740\u5931\u8d25", e);
        }
        Log.debug("\u83b7\u53d6\u5230Storage\u8fde\u63a5\u5730\u5740{}", (Object)address);
        return this.executeCmd(address, conn, command);
    }

    private Connection getConnection(InetSocketAddress address) {
        Connection conn;
        try {
            conn = (Connection)this.pool.borrowObject(address);
            this.trackerLocator.setActive(address, true);
        }
        catch (FastDfsConnectException e) {
            this.trackerLocator.setActive(address, false);
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("\u4ece\u8fde\u63a5\u6c60\u4e2d\u83b7\u53d6\u8fde\u63a5\u5f02\u5e38", e);
        }
        return conn;
    }

    private <T> T executeCmd(InetSocketAddress address, Connection conn, AbstractCommand<T> command) {
        try {
            Log.debug("\u53d1\u9001\u8bf7\u6c42, \u670d\u52a1\u5668\u5730\u5740[{}], \u8bf7\u6c42\u7c7b\u578b[{}]", (Object)address, (Object)command.getClass().getSimpleName());
            T t = command.execute(conn);
            return t;
        }
        catch (FastDfsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("\u53d1\u9001FastDFS\u8bf7\u6c42\u5f02\u5e38", e);
        }
        finally {
            try {
                if (null != conn) {
                    this.pool.returnObject(address, conn);
                }
            }
            catch (Exception e) {
                log.error("\u5f52\u8fd8\u8fde\u63a5\u5230\u8fde\u63a5\u6c60\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void dumpPoolInfo() {
        if (log.isDebugEnabled()) {
            String tmp = "\r\n#=======================================================================================================================#\r\n# ------Dump Pool Info------\r\n#\t \u6d3b\u52a8\u8fde\u63a5\uff1a" + this.pool.getNumActive() + "\r\n#\t \u7a7a\u95f2\u8fde\u63a5\uff1a" + this.pool.getNumIdle() + "\r\n#\t \u6b63\u5728\u4f7f\u7528\u7684\u8fde\u63a5\uff1a" + this.pool.getNumWaiters() + "\r\n#\t \u8fde\u63a5\u83b7\u53d6\u603b\u6570\u7edf\u8ba1\uff1a" + this.pool.getBorrowedCount() + "\r\n#\t \u8fde\u63a5\u8fd4\u56de\u603b\u6570\u7edf\u8ba1\uff1a" + this.pool.getReturnedCount() + "\r\n#\t \u8fde\u63a5\u521b\u5efa\u603b\u6570\u7edf\u8ba1\uff1a" + this.pool.getCreatedCount() + "\r\n#\t \u8fde\u63a5\u9500\u6bc1\u603b\u6570\u7edf\u8ba1\uff1a" + this.pool.getDestroyedCount() + "\r\n#\t \u8fde\u63a5\u9500\u6bc1(\u56e0\u4e3a\u8fde\u63a5\u4e0d\u53ef\u7528)\u603b\u6570\u7edf\u8ba1\uff1a" + this.pool.getDestroyedByBorrowValidationCount() + "\r\n#\t \u8fde\u63a5\u9500\u6bc1(\u56e0\u4e3a\u8fde\u63a5\u88ab\u56de\u6536)\u603b\u6570\u7edf\u8ba1\uff1a" + this.pool.getDestroyedByEvictorCount() + "\r\n#=======================================================================================================================#\r\n";
            Log.debug(tmp, new Object[0]);
        }
    }

    public ConnectionPool getPool() {
        return this.pool;
    }

    public void setPool(ConnectionPool pool) {
        this.pool = pool;
    }
}

