/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.client;

import cn.novelweb.tool.upload.fastdfs.client.StorageClient;
import cn.novelweb.tool.upload.fastdfs.client.TrackerClient;
import cn.novelweb.tool.upload.fastdfs.conn.CommandExecutor;
import cn.novelweb.tool.upload.fastdfs.exception.FastDfsServerException;
import cn.novelweb.tool.upload.fastdfs.model.FileInfo;
import cn.novelweb.tool.upload.fastdfs.model.MateData;
import cn.novelweb.tool.upload.fastdfs.model.StorageNode;
import cn.novelweb.tool.upload.fastdfs.model.StorageNodeInfo;
import cn.novelweb.tool.upload.fastdfs.model.StorePath;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.AppendFileCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.DeleteFileCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.DownloadFileCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.GetMetadataCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.ModifyCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.QueryFileInfoCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.SetMetadataCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.TruncateCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.UploadFileCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.UploadSlaveFileCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.callback.DownloadCallback;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.enums.StorageMetadataSetType;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStorageClient
implements StorageClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultStorageClient.class);
    private CommandExecutor commandExecutor;
    private TrackerClient trackerClient;

    public DefaultStorageClient(CommandExecutor commandExecutor, TrackerClient trackerClient) {
        this.commandExecutor = commandExecutor;
        this.trackerClient = trackerClient;
    }

    @Override
    public StorePath uploadFile(String groupName, InputStream inputStream, long fileSize, String fileExtName) {
        StorageNode storageNode = this.trackerClient.getStorageNode(groupName);
        UploadFileCommandAbstract command = new UploadFileCommandAbstract(storageNode.getStoreIndex(), inputStream, fileExtName, fileSize, false);
        return this.commandExecutor.execute(storageNode.getInetSocketAddress(), command);
    }

    @Override
    public StorePath uploadSlaveFile(String groupName, String masterFilename, InputStream inputStream, long fileSize, String prefixName, String fileExtName) {
        StorageNodeInfo storageNodeInfo = this.trackerClient.getFetchStorageAndUpdate(groupName, masterFilename);
        UploadSlaveFileCommandAbstract command = new UploadSlaveFileCommandAbstract(inputStream, fileSize, masterFilename, prefixName, fileExtName);
        return this.commandExecutor.execute(storageNodeInfo.getInetSocketAddress(), command);
    }

    @Override
    public Set<MateData> getMetadata(String groupName, String path) {
        try {
            StorageNodeInfo storageNodeInfo = this.trackerClient.getFetchStorage(groupName, path);
            GetMetadataCommandAbstract command = new GetMetadataCommandAbstract(groupName, path);
            return this.commandExecutor.execute(storageNodeInfo.getInetSocketAddress(), command);
        }
        catch (Throwable e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5143\u4fe1\u606f", e);
            return new HashSet<MateData>();
        }
    }

    @Override
    public boolean overwriteMetadata(String groupName, String path, Set<MateData> metaDataSet) {
        try {
            StorageNodeInfo storageNodeInfo = this.trackerClient.getFetchStorageAndUpdate(groupName, path);
            SetMetadataCommandAbstract command = new SetMetadataCommandAbstract(groupName, path, metaDataSet, StorageMetadataSetType.STORAGE_SET_METADATA_FLAG_OVERWRITE);
            this.commandExecutor.execute(storageNodeInfo.getInetSocketAddress(), command);
        }
        catch (Throwable e) {
            log.error("\u4fee\u6539\u6587\u4ef6\u5143\u4fe1\u606f\uff08\u8986\u76d6\uff09\u5931\u8d25", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean mergeMetadata(String groupName, String path, Set<MateData> metaDataSet) {
        try {
            StorageNodeInfo storageNodeInfo = this.trackerClient.getFetchStorageAndUpdate(groupName, path);
            SetMetadataCommandAbstract command = new SetMetadataCommandAbstract(groupName, path, metaDataSet, StorageMetadataSetType.STORAGE_SET_METADATA_FLAG_MERGE);
            this.commandExecutor.execute(storageNodeInfo.getInetSocketAddress(), command);
        }
        catch (Throwable e) {
            log.error("\u4fee\u6539\u6587\u4ef6\u5143\u4fe1\u606f\uff08\u5408\u5e76\uff09\u5931\u8d25", e);
            return false;
        }
        return true;
    }

    @Override
    public FileInfo queryFileInfo(String groupName, String path) {
        FileInfo fileInfo = null;
        StorageNodeInfo storageNodeInfo = this.trackerClient.getFetchStorage(groupName, path);
        QueryFileInfoCommandAbstract command = new QueryFileInfoCommandAbstract(groupName, path);
        try {
            fileInfo = this.commandExecutor.execute(storageNodeInfo.getInetSocketAddress(), command);
        }
        catch (FastDfsServerException e) {
            if (e.getErrorCode() == 2) {
                log.error("\u83b7\u53d6\u6587\u4ef6\u7684\u4fe1\u606f\u5f02\u5e38,ErrorCode=[{}], ErrorMessage=[{}]", (Object)e.getErrorCode(), (Object)e.getMessage());
            }
            throw e;
        }
        return fileInfo;
    }

    @Override
    public boolean deleteFile(String groupName, String path) {
        try {
            StorageNodeInfo storageNodeInfo = this.trackerClient.getFetchStorageAndUpdate(groupName, path);
            DeleteFileCommandAbstract command = new DeleteFileCommandAbstract(groupName, path);
            this.commandExecutor.execute(storageNodeInfo.getInetSocketAddress(), command);
        }
        catch (Throwable e) {
            log.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25", e);
            return false;
        }
        return true;
    }

    @Override
    public <T> T downloadFile(String groupName, String path, DownloadCallback<T> callback) {
        long fileOffset = 0L;
        long fileSize = 0L;
        return this.downloadFile(groupName, path, fileOffset, fileSize, callback);
    }

    @Override
    public <T> T downloadFile(String groupName, String path, long fileOffset, long fileSize, DownloadCallback<T> callback) {
        StorageNodeInfo storageNodeInfo = this.trackerClient.getFetchStorage(groupName, path);
        DownloadFileCommandAbstract<T> command = new DownloadFileCommandAbstract<T>(groupName, path, fileOffset, fileSize, callback);
        return this.commandExecutor.execute(storageNodeInfo.getInetSocketAddress(), command);
    }

    @Override
    public StorePath uploadFile(InputStream inputStream, long fileSize, String fileExtName, Set<MateData> metaDataSet) {
        StorageNode storageNode = this.trackerClient.getStorageNode();
        UploadFileCommandAbstract command = new UploadFileCommandAbstract(storageNode.getStoreIndex(), inputStream, fileExtName, fileSize, false);
        StorePath storePath = this.commandExecutor.execute(storageNode.getInetSocketAddress(), command);
        if (metaDataSet == null || metaDataSet.size() <= 0) {
            return storePath;
        }
        SetMetadataCommandAbstract cmd = new SetMetadataCommandAbstract(storePath.getGroup(), storePath.getPath(), metaDataSet, StorageMetadataSetType.STORAGE_SET_METADATA_FLAG_OVERWRITE);
        this.commandExecutor.execute(storageNode.getInetSocketAddress(), command);
        return storePath;
    }

    @Override
    public StorePath uploadAppenderFile(String groupName, InputStream inputStream, long fileSize, String fileExtName) {
        StorageNode storageNode = this.trackerClient.getStorageNode(groupName);
        UploadFileCommandAbstract command = new UploadFileCommandAbstract(storageNode.getStoreIndex(), inputStream, fileExtName, fileSize, true);
        return this.commandExecutor.execute(storageNode.getInetSocketAddress(), command);
    }

    @Override
    public void appendFile(String groupName, String path, InputStream inputStream, long fileSize) {
        StorageNodeInfo storageNodeInfo = this.trackerClient.getFetchStorageAndUpdate(groupName, path);
        AppendFileCommandAbstract command = new AppendFileCommandAbstract(inputStream, fileSize, path);
        this.commandExecutor.execute(storageNodeInfo.getInetSocketAddress(), command);
    }

    @Override
    public void modifyFile(String groupName, String path, InputStream inputStream, long fileSize, long fileOffset) {
        StorageNodeInfo storageNodeInfo = this.trackerClient.getFetchStorageAndUpdate(groupName, path);
        ModifyCommandAbstract command = new ModifyCommandAbstract(path, inputStream, fileSize, fileOffset);
        this.commandExecutor.execute(storageNodeInfo.getInetSocketAddress(), command);
    }

    @Override
    public void truncateFile(String groupName, String path, long truncatedFileSize) {
        StorageNodeInfo storageNodeInfo = this.trackerClient.getFetchStorageAndUpdate(groupName, path);
        TruncateCommandAbstract command = new TruncateCommandAbstract(path, truncatedFileSize);
        this.commandExecutor.execute(storageNodeInfo.getInetSocketAddress(), command);
    }

    @Override
    public void truncateFile(String groupName, String path) {
        long truncatedFileSize = 0L;
        this.truncateFile(groupName, path, truncatedFileSize);
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public TrackerClient getTrackerClient() {
        return this.trackerClient;
    }

    public void setTrackerClient(TrackerClient trackerClient) {
        this.trackerClient = trackerClient;
    }
}

