/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.send.message;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.novelweb.tool.send.message.aliyuncs.AliYunSignature;
import cn.novelweb.tool.send.message.aliyuncs.AliYunSmsConfig;
import cn.novelweb.tool.send.message.aliyuncs.AliYunSmsConfigAbbreviations;
import cn.novelweb.tool.send.message.qcloudsms.TencentCloudSignature;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsUtil {
    private static final Logger log = LoggerFactory.getLogger(SmsUtil.class);

    public static String aliYunSendSms(final AliYunSmsConfig aliYunSmsConfig, final String phone, final String templateCode, final String outId, final String smsUpExtendCode, final JSONObject templateParam) {
        Assert.isTrue((boolean)Validator.isMobile((CharSequence)phone), (String)"\u624b\u673a\u53f7\u4e0d\u6b63\u786e", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)templateCode, (String)"\u77ed\u4fe1\u6a21\u677fid\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)aliYunSmsConfig, (String)"\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        aliYunSmsConfig.setAction("SendSms");
        TreeMap<String, String> parameters = new TreeMap<String, String>(){
            {
                this.put("SignatureMethod", aliYunSmsConfig.getSignatureMethod());
                this.put("SignatureNonce", aliYunSmsConfig.getSignatureNonce());
                this.put("AccessKeyId", aliYunSmsConfig.getAccessKeyId());
                this.put("SignatureVersion", aliYunSmsConfig.getSignatureVersion());
                this.put("Timestamp", aliYunSmsConfig.getTimestamp());
                this.put("Format", aliYunSmsConfig.getFormat().getFormat());
                this.put("Action", aliYunSmsConfig.getAction());
                this.put("Version", aliYunSmsConfig.getVersion());
                this.put("RegionId", aliYunSmsConfig.getRegionId());
                this.put("PhoneNumbers", phone);
                this.put("SignName", aliYunSmsConfig.getSignName());
                this.put("TemplateCode", templateCode);
                this.put("TemplateParam", templateParam.toJSONString());
                this.put("OutId", outId);
                this.put("SmsUpExtendCode", smsUpExtendCode);
            }
        };
        JSONObject aliYunSignature = AliYunSignature.getAliYunSignature((Map<String, String>)parameters, aliYunSmsConfig.getAccessKeySecret(), aliYunSmsConfig.getDomain().getDomain());
        Assert.isFalse((boolean)aliYunSignature.isEmpty(), (String)"\u83b7\u53d6\u77ed\u4fe1\u7b7e\u540d\u5931\u8d25", (Object[])new Object[0]);
        return HttpRequest.get((String)aliYunSignature.getString("requestUrl")).timeout(-1).execute().body();
    }

    public static String aliYunSendSms(AliYunSmsConfigAbbreviations aliYunSmsConfigAbbreviations) {
        Assert.notNull((Object)aliYunSmsConfigAbbreviations, (String)"\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        AliYunSmsConfig aliYunSmsConfig = AliYunSmsConfig.init();
        aliYunSmsConfig.setAccessKeyId(aliYunSmsConfigAbbreviations.getAccessKeyId());
        aliYunSmsConfig.setAccessKeySecret(aliYunSmsConfigAbbreviations.getAccessKeySecret());
        aliYunSmsConfig.setSignName(aliYunSmsConfigAbbreviations.getSignName());
        return SmsUtil.aliYunSendSms(aliYunSmsConfig, aliYunSmsConfigAbbreviations.getPhone(), aliYunSmsConfigAbbreviations.getTemplateCode(), aliYunSmsConfigAbbreviations.getOutId(), null, aliYunSmsConfigAbbreviations.getTemplateParam());
    }

    public static String tencentCloudSendSms(final JSONArray phoneNumber, final String templateId, final JSONArray templateParam, final String extendCode, final String sessionContext, final String senderId, final String appId, final String sign, String secretId, String secretKey) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(8){
            {
                super(x0);
                this.put("PhoneNumberSet", phoneNumber);
                this.put("TemplateID", templateId);
                this.put("TemplateParamSet", templateParam);
                this.put("SmsSdkAppid", appId);
                this.put("Sign", sign);
                this.put("ExtendCode", extendCode);
                this.put("SessionContext", sessionContext);
                this.put("SenderId", senderId);
            }
        };
        JSONObject signature = TencentCloudSignature.getTencentCloudSignature((Map<String, Object>)parameters, "sms.tencentcloudapi.com", secretId, secretKey);
        return ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)"https://sms.tencentcloudapi.com/").header("Content-Type", "application/json; charset=utf-8")).header("Host", "sms.tencentcloudapi.com")).header("Authorization", signature.getString("signature"))).header("X-TC-Action", "SendSms")).header("X-TC-Timestamp", signature.getString("timestamp"))).header("X-TC-Version", "2019-07-11")).header("X-TC-RequestClient", "SDK_JAVA_3.1.130")).header("X-TC-Region", "")).body(JSON.toJSONString((Object)parameters).getBytes(StandardCharsets.UTF_8)).timeout(-1).execute().body();
    }

    public static String tencentCloudSendSms(String templateId, JSONArray templateParam, String appId, String sign, String secretId, String secretKey, String ... phoneNumber) {
        return SmsUtil.tencentCloudSendSms(JSONArray.parseArray((String)JSONArray.toJSONString((Object)phoneNumber)), templateId, templateParam, "", "", "", appId, sign, secretId, secretKey);
    }

    public static String tencentCloudSendSms(String phoneNumber, String content, String appId, String appKey) {
        long randomNumber = new Random(DateUtil.currentSeconds()).nextLong() % 900000L + 100000L;
        long timeStamp = DateUtil.currentSeconds();
        JSONObject mobile = new JSONObject();
        mobile.put("nationcode", (Object)"86");
        mobile.put("mobile", (Object)phoneNumber);
        JSONObject requestBody = new JSONObject();
        requestBody.put("tel", (Object)mobile);
        requestBody.put("type", (Object)0);
        requestBody.put("msg", (Object)content);
        String signature = StrUtil.format((CharSequence)"appkey={}&random={}&time={}&mobile={}", (Object[])new Object[]{appKey, randomNumber, timeStamp, phoneNumber});
        requestBody.put("sig", (Object)DigestUtils.sha256Hex((String)signature));
        requestBody.put("time", (Object)timeStamp);
        String url = StrUtil.format((CharSequence)"https://yun.tim.qq.com/v5/tlssmssvr/sendsms?sdkappid={}&random={}", (Object[])new Object[]{appId, randomNumber});
        return ((HttpRequest)HttpRequest.post((String)url).header("Conetent-Type", "application/json")).body(requestBody.toJSONString()).timeout(-1).execute().body();
    }
}

