/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.local;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.novelweb.tool.http.Result;
import cn.novelweb.tool.upload.file.FileInfo;
import cn.novelweb.tool.upload.local.pojo.UploadFileParam;
import cn.novelweb.tool.util.MimeTypes;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartFile;

public class LocalUpload {
    private static final Logger log = LoggerFactory.getLogger(LocalUpload.class);
    public static String defaultPath = String.format("log%suploader", Character.valueOf(File.separatorChar));

    public static Result<JSONArray> checkFileMd5(String fileMd5, String fileName, String confFilePath, String tmpFilePath) throws Exception {
        boolean isParamEmpty;
        boolean bl = isParamEmpty = StringUtils.isBlank((String)fileMd5) || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)confFilePath) || StringUtils.isBlank((String)tmpFilePath);
        if (isParamEmpty) {
            throw new Exception("\u53c2\u6570\u503c\u4e3a\u7a7a");
        }
        File confFile = new File(confFilePath + File.separatorChar + fileName + ".conf");
        boolean isTmpFileEmpty = new File(tmpFilePath + File.separatorChar + fileName + "_tmp").exists();
        if (confFile.exists() && isTmpFileEmpty) {
            byte[] completeList = FileUtils.readFileToByteArray((File)confFile);
            ArrayList<String> missChunkList = new ArrayList<String>();
            for (int i = 0; i < completeList.length; ++i) {
                if (completeList[i] == 127) continue;
                missChunkList.add(Integer.toString(i));
            }
            return Result.ok(HttpStatus.PARTIAL_CONTENT.value(), "\u6587\u4ef6\u5df2\u7ecf\u4e0a\u4f20\u4e86\u4e00\u90e8\u5206", JSONArray.parseArray((String)JSON.toJSONString(missChunkList)));
        }
        boolean isFileEmpty = new File(tmpFilePath + File.separatorChar + fileName).exists();
        if (isFileEmpty && confFile.exists()) {
            return Result.ok(HttpStatus.OK.value(), "\u6587\u4ef6\u5df2\u4e0a\u4f20\u6210\u529f");
        }
        return Result.ok(HttpStatus.NOT_FOUND.value(), "\u6587\u4ef6\u4e0d\u5b58\u5728");
    }

    public static Result<JSONArray> checkFileMd5(String fileMd5, String fileName) throws Exception {
        return LocalUpload.checkFileMd5(fileMd5, fileName, defaultPath + File.separatorChar + fileMd5, defaultPath + File.separatorChar + fileMd5);
    }

    public static synchronized Result<FileInfo> fragmentFileUploader(UploadFileParam param, String confFilePath, String filePath, long chunkSize, HttpServletRequest request) throws Exception {
        boolean isParamEmpty;
        boolean bl = isParamEmpty = StringUtils.isBlank((String)filePath) || StringUtils.isBlank((String)confFilePath) && param.getFile() == null;
        if (isParamEmpty) {
            throw new Exception("\u53c2\u6570\u503c\u4e3a\u7a7a");
        }
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u5185\u5bb9\u4e0d\u662f\u6709\u6548\u7684multipart/form-data\u7c7b\u578b.");
        }
        try {
            File confFile = FileUtil.file((File)FileUtil.mkdir((String)confFilePath), (String)String.format("%s.conf", param.getName()));
            RandomAccessFile accessConfFile = new RandomAccessFile(confFile, "rw");
            accessConfFile.setLength(param.getChunks());
            accessConfFile.seek(param.getChunk());
            accessConfFile.write(127);
            accessConfFile.close();
            File tmpFile = FileUtil.file((File)FileUtil.mkdir((String)filePath), (String)String.format("%s_tmp", param.getName()));
            RandomAccessFile accessTmpFile = new RandomAccessFile(tmpFile, "rw");
            long offset = chunkSize * (long)param.getChunk();
            accessTmpFile.seek(offset);
            accessTmpFile.write(param.getFile().getBytes());
            accessTmpFile.close();
            byte[] completeList = FileUtils.readFileToByteArray((File)confFile);
            int isComplete = 127;
            for (int i = 0; i < completeList.length && isComplete == 127; ++i) {
                isComplete = (byte)(isComplete & completeList[i]);
            }
            if (isComplete != 127) {
                return Result.ok(HttpStatus.OK.value(), "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
            }
            boolean isSuccess = LocalUpload.renameFile(tmpFile, param.getName());
            if (!isSuccess) {
                throw new Exception("\u6587\u4ef6\u91cd\u547d\u540d\u65f6\u5931\u8d25");
            }
            FileInfo fileInfo = FileInfo.builder().hash(param.getMd5()).name(param.getName()).type(MimeTypes.getInstance().getMimeTypes(param.getName())).path(tmpFile.getParent() + File.separatorChar + param.getName()).createTime(System.currentTimeMillis()).build();
            return Result.ok(HttpStatus.CREATED.value(), "\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210", fileInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Result.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
    }

    public static Result<FileInfo> fragmentFileUploader(UploadFileParam param, long chunkSize, HttpServletRequest request) throws Exception {
        return LocalUpload.fragmentFileUploader(param, defaultPath + File.separatorChar + param.getMd5(), defaultPath + File.separatorChar + param.getMd5(), chunkSize, request);
    }

    public static Result<FileInfo> regularFileUploader(UploadFileParam param, String filePath) throws Exception {
        boolean isParamEmpty;
        boolean bl = isParamEmpty = StringUtils.isBlank((String)filePath) || StringUtils.isBlank((String)param.getName()) && param.getFile() == null;
        if (isParamEmpty) {
            throw new Exception("\u53c2\u6570\u503c\u4e3a\u7a7a");
        }
        File uploadFolder = new File(filePath);
        if (!uploadFolder.exists() && !uploadFolder.mkdirs()) {
            return Result.fail(HttpStatus.FORBIDDEN.value(), "\u4e0a\u4f20\u6240\u9700\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25");
        }
        File uploadFile = new File(filePath + File.separatorChar + param.getName());
        param.getFile().transferTo(uploadFile);
        if (uploadFile.length() != param.getFile().getSize()) {
            return Result.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        FileInfo fileInfo = FileInfo.builder().hash(param.getMd5()).name(param.getName()).type(MimeTypes.getInstance().getMimeTypes(param.getName())).path(uploadFile.getPath()).createTime(System.currentTimeMillis()).build();
        return Result.ok(HttpStatus.CREATED.value(), "\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210", fileInfo);
    }

    public static Result<FileInfo> regularFileUploader(UploadFileParam param) throws Exception {
        boolean isParamEmpty;
        boolean bl = isParamEmpty = StringUtils.isBlank((String)param.getName()) && param.getFile() == null;
        if (isParamEmpty) {
            throw new Exception("\u53c2\u6570\u503c\u4e3a\u7a7a");
        }
        param.setName(System.currentTimeMillis() + "." + FileNameUtil.extName((String)param.getFile().getOriginalFilename()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(String.format("yyyy%sMM%sdd", Character.valueOf(File.separatorChar), Character.valueOf(File.separatorChar)));
        return LocalUpload.regularFileUploader(param, defaultPath + File.separatorChar + simpleDateFormat.format(System.currentTimeMillis()));
    }

    public static Result<FileInfo> regularFileUploader(MultipartFile file) throws Exception {
        return LocalUpload.regularFileUploader(UploadFileParam.builder().file(file).name(file.getOriginalFilename()).build());
    }

    private static boolean renameFile(File toBeRenamed, String toFileNewName) {
        if (!toBeRenamed.exists() || toBeRenamed.isDirectory()) {
            return false;
        }
        File newFile = new File(toBeRenamed.getParent() + File.separatorChar + toFileNewName);
        return toBeRenamed.renameTo(newFile);
    }
}

