/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.protocol;

import cn.novelweb.tool.upload.fastdfs.exception.FastDfsServerException;
import cn.novelweb.tool.upload.fastdfs.utils.BytesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class ProtocolHead {
    private static final int HEAD_LENGTH = 10;
    private long contentLength = 0L;
    private byte cmd;
    private byte status = 0;

    public ProtocolHead(byte cmd) {
        this.cmd = cmd;
    }

    private ProtocolHead(long contentLength, byte cmd, byte status) {
        this.contentLength = contentLength;
        this.cmd = cmd;
        this.status = status;
    }

    static ProtocolHead createFromInputStream(InputStream ins) throws IOException {
        byte[] header = new byte[10];
        int bytes = ins.read(header);
        if (bytes != header.length) {
            throw new IOException("\u63a5\u6536\u6570\u636e\u5305\u5927\u5c0f\u4e0d\u7b49\u4e8e\u8bf7\u6c42\u5934\u4e2d\u6307\u5b9a\u7684\u5927\u5c0f " + bytes + " != " + header.length);
        }
        long returnContentLength = BytesUtil.buff2long(header, 0);
        byte returnCmd = header[8];
        byte returnStatus = header[9];
        return new ProtocolHead(returnContentLength, returnCmd, returnStatus);
    }

    byte[] toByte() {
        byte[] header = new byte[10];
        Arrays.fill(header, (byte)0);
        byte[] hexLen = BytesUtil.long2buff(this.contentLength);
        System.arraycopy(hexLen, 0, header, 0, hexLen.length);
        header[8] = this.cmd;
        header[9] = this.status;
        return header;
    }

    boolean validateResponseHead() throws IOException {
        if (this.cmd != 100) {
            throw new IOException("\u63a5\u6536\u547d\u4ee4: [" + this.cmd + "] \u4e0d\u6b63\u786e, \u5e94\u8be5\u662f: [" + 100 + "]");
        }
        if (this.status != 0) {
            throw FastDfsServerException.byCode(this.status);
        }
        if (this.contentLength < 0L) {
            throw new IOException("\u63a5\u6536\u5185\u5bb9\u957f\u5ea6\u5c0f\u4e8e0: " + this.contentLength + " < 0!");
        }
        return true;
    }

    long getContentLength() {
        return this.contentLength;
    }

    void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public byte getCmd() {
        return this.cmd;
    }

    public byte getStatus() {
        return this.status;
    }

    public String toString() {
        return "ProtoHead [contentLength=" + this.contentLength + ", cmd=" + this.cmd + ", status=" + this.status + "]";
    }
}

