/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.novelweb.tool.io.FileUtils;
import cn.novelweb.tool.upload.fastdfs.callback.FastDfsUploadCompletionHandler;
import cn.novelweb.tool.upload.fastdfs.client.DefaultStorageClient;
import cn.novelweb.tool.upload.fastdfs.client.DefaultTrackerClient;
import cn.novelweb.tool.upload.fastdfs.client.StorageClient;
import cn.novelweb.tool.upload.fastdfs.client.TrackerClient;
import cn.novelweb.tool.upload.fastdfs.config.FastDfsConfig;
import cn.novelweb.tool.upload.fastdfs.conn.Connection;
import cn.novelweb.tool.upload.fastdfs.conn.DefaultCommandExecutor;
import cn.novelweb.tool.upload.fastdfs.model.FileInfo;
import cn.novelweb.tool.upload.fastdfs.model.MateData;
import cn.novelweb.tool.upload.fastdfs.model.StorageNode;
import cn.novelweb.tool.upload.fastdfs.model.StorePath;
import cn.novelweb.tool.upload.fastdfs.pool.ConnectionPool;
import cn.novelweb.tool.upload.fastdfs.pool.PooledConnectionFactory;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.callback.DownloadCallback;
import cn.novelweb.tool.upload.fastdfs.utils.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastDfsClient {
    private static final Logger log = LoggerFactory.getLogger(FastDfsClient.class);
    private static TrackerClient trackerClient;
    private static StorageClient storageClient;
    private static boolean isSuccessInit;

    public static void init(String confFileName) {
        FastDfsConfig.init(confFileName);
    }

    public static void init(FastDfsConfig fastDfsConfig) {
        Log.debugLog = fastDfsConfig.getDebugLog();
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory(fastDfsConfig.getSoTimeout(), fastDfsConfig.getConnectTimeout());
        GenericKeyedObjectPoolConfig conf = new GenericKeyedObjectPoolConfig();
        conf.setMaxTotal(fastDfsConfig.getMaxTotal());
        conf.setMaxTotalPerKey(fastDfsConfig.getMaxTotalPerKey());
        conf.setMaxIdlePerKey(fastDfsConfig.getMaxIdlePerKey());
        ConnectionPool connectionPool = new ConnectionPool((KeyedPooledObjectFactory<InetSocketAddress, Connection>)pooledConnectionFactory, (GenericKeyedObjectPoolConfig<Connection>)conf);
        String[] split = fastDfsConfig.getTrackerServers().split(",");
        HashSet<String> trackerSet = new HashSet<String>(split.length);
        trackerSet.addAll(Arrays.asList(split));
        DefaultCommandExecutor commandExecutor = new DefaultCommandExecutor(trackerSet, connectionPool);
        trackerClient = new DefaultTrackerClient(commandExecutor);
        storageClient = new DefaultStorageClient(commandExecutor, trackerClient);
        isSuccessInit = true;
    }

    public static StorePath uploader(InputStream stream, long length, String ext) {
        StorageNode node = trackerClient.getStorageNode();
        if (node == null) {
            return null;
        }
        return FastDfsClient.uploader(node.getGroupName(), stream, length, ext);
    }

    public static StorePath uploader(String group, InputStream stream, long length, String ext) {
        if (FastDfsClient.successInit()) {
            return null;
        }
        return storageClient.uploadFile(group, stream, length, ext);
    }

    public static void asynchronousUpload(String group, InputStream stream, long length, String ext, FastDfsUploadCompletionHandler handler) {
        if (FastDfsClient.successInit()) {
            return;
        }
        ThreadUtil.execAsync(() -> {
            StorePath storePath = storageClient.uploadFile(group, stream, length, ext);
            handler.complete(storePath);
        });
    }

    public static StorePath characterStringUploader(String group, String str, String ext, String charsetName) {
        ByteArrayInputStream inputStream = IoUtil.toStream((String)str, (String)charsetName);
        return FastDfsClient.uploader(group, inputStream, inputStream.available(), ext);
    }

    public static StorePath characterStringUploader(String str, String ext) {
        StorageNode node = trackerClient.getStorageNode();
        if (node == null) {
            return null;
        }
        return FastDfsClient.characterStringUploader(node.getGroupName(), str, ext, "UTF-8");
    }

    public static StorePath uploader(File file) {
        try {
            FileInputStream stream = new FileInputStream(file.getAbsolutePath());
            StorageNode node = trackerClient.getStorageNode();
            if (node == null) {
                return null;
            }
            return FastDfsClient.uploader(node.getGroupName(), stream, file.length(), FileUtil.extName((String)file.getAbsolutePath()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StorePath uploader(String group, File file) {
        try {
            FileInputStream stream = new FileInputStream(file.getAbsolutePath());
            return FastDfsClient.uploader(group, stream, file.length(), FileUtil.extName((String)file.getAbsolutePath()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean delete(String group, String path) {
        if (FastDfsClient.successInit()) {
            return false;
        }
        return storageClient.deleteFile(group, path);
    }

    public static boolean delete(String fileId) {
        if (FastDfsClient.successInit()) {
            return false;
        }
        int i = fileId.indexOf("/");
        return storageClient.deleteFile(fileId.substring(0, i), fileId.substring(i + 1));
    }

    public static Set<MateData> getMetadata(String groupName, String path) {
        if (FastDfsClient.successInit()) {
            return null;
        }
        return storageClient.getMetadata(groupName, path);
    }

    public static FileInfo queryFileInfo(String groupName, String path) {
        if (FastDfsClient.successInit()) {
            return null;
        }
        return storageClient.queryFileInfo(groupName, path);
    }

    public static <T> T downloadFile(String groupName, String path, DownloadCallback<T> callback) {
        if (FastDfsClient.successInit()) {
            return null;
        }
        return storageClient.downloadFile(groupName, path, callback);
    }

    public static String characterStringDownload(String groupName, String path) {
        if (FastDfsClient.successInit()) {
            return "";
        }
        return storageClient.downloadFile(groupName, path, inputStream -> {
            String string = FileUtils.inputStreamToString(inputStream);
            inputStream.close();
            return string;
        });
    }

    public static String characterStringDownload(String fileId) {
        if (FastDfsClient.successInit()) {
            return "";
        }
        int i = fileId.indexOf("/");
        return FastDfsClient.characterStringDownload(fileId.substring(0, i), fileId.substring(i + 1));
    }

    public static TrackerClient getTrackerClient() {
        return trackerClient;
    }

    public static StorageClient getStorageClient() {
        return storageClient;
    }

    private static boolean successInit() {
        if (!isSuccessInit) {
            log.error("\u8bf7\u8c03\u7528FastDfsClient.init()\u65b9\u6cd5\u5b8c\u6210\u521d\u59cb\u5316\u8bbe\u7f6e");
        }
        return !isSuccessInit;
    }

    static {
        isSuccessInit = false;
    }
}

