/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.send.message.qcloudsms;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class TencentCloudSignature {
    public static JSONObject getTencentCloudSignature(Map<String, Object> parameters, String endpoint, String secretId, String secretKey) {
        String canonicalRequest = StrUtil.format((CharSequence)"POST\n/\n\n{}\ncontent-type;host\n{}", (Object[])new Object[]{StrUtil.format((CharSequence)"content-type:application/json; charset=utf-8\nhost:{}\n", (Object[])new Object[]{endpoint}), TencentCloudSignature.sha256Hex(JSON.toJSONString(parameters))});
        String timestamp = String.valueOf(DateUtil.currentSeconds());
        String date = DateUtil.format((Date)new DateTime(TimeZone.getTimeZone("UTC")), (String)"yyyy-MM-dd");
        String credentialScope = StrUtil.format((CharSequence)"{}/{}/tc3_request", (Object[])new Object[]{date, endpoint.split("\\.")[0]});
        String stringToSign = StrUtil.format((CharSequence)"TC3-HMAC-SHA256\n{}\n{}\n{}", (Object[])new Object[]{timestamp, credentialScope, TencentCloudSignature.sha256Hex(canonicalRequest)});
        byte[] secretDate = TencentCloudSignature.hmac256(("TC3" + secretKey).getBytes(StandardCharsets.UTF_8), date);
        byte[] secretService = TencentCloudSignature.hmac256(secretDate, endpoint.split("\\.")[0]);
        byte[] secretSigning = TencentCloudSignature.hmac256(secretService, "tc3_request");
        String authorization = StrUtil.format((CharSequence)"TC3-HMAC-SHA256 Credential={}/{}, SignedHeaders=content-type;host, Signature={}", (Object[])new Object[]{secretId, credentialScope, DatatypeConverter.printHexBinary((byte[])TencentCloudSignature.hmac256(secretSigning, stringToSign)).toLowerCase()});
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("signature", (Object)authorization);
        jsonObject.put("timestamp", (Object)timestamp);
        return jsonObject;
    }

    private static byte[] hmac256(byte[] key, String msg) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, mac.getAlgorithm());
            mac.init(secretKeySpec);
            return mac.doFinal(msg.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String sha256Hex(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] d = md.digest(s.getBytes(StandardCharsets.UTF_8));
            return DatatypeConverter.printHexBinary((byte[])d).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }
}

