/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.send.message.aliyuncs;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Encoder;

public class AliYunSignature {
    public static JSONObject getAliYunSignature(Map<String, String> parameters, String accessKeySecret, String domain) {
        parameters = MapUtil.filter(parameters, o -> StrUtil.isNotBlank((CharSequence)((CharSequence)o.getValue())));
        try {
            Iterator it = parameters.keySet().iterator();
            StringBuilder sortQueryStringTmp = new StringBuilder();
            while (it.hasNext()) {
                String key = (String)it.next();
                sortQueryStringTmp.append("&").append(AliYunSignature.specialUrlEncode(key)).append("=").append(AliYunSignature.specialUrlEncode((String)parameters.get(key)));
            }
            String stringToSign = "GET&" + AliYunSignature.specialUrlEncode("/") + "&" + AliYunSignature.specialUrlEncode(sortQueryStringTmp.substring(1));
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(StrUtil.format((CharSequence)"{}&", (Object[])new Object[]{accessKeySecret}).getBytes(StandardCharsets.UTF_8), "HmacSHA1"));
            byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            String sign = new BASE64Encoder().encode(signData);
            String signature = AliYunSignature.specialUrlEncode(sign);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("signature", (Object)signature);
            jsonObject.put("parameters", (Object)sortQueryStringTmp);
            jsonObject.put("requestUrl", (Object)StrUtil.format((CharSequence)"http://{}/?Signature={}{}", (Object[])new Object[]{domain, signature, sortQueryStringTmp}));
            return jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JSONObject();
        }
    }

    private static String specialUrlEncode(String value) throws Exception {
        return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }
}

