/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.img;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagesUtil {
    private static final Logger log = LoggerFactory.getLogger(ImagesUtil.class);
    public static String[] IMAGES_TYPE = new String[]{"jpg", "png"};

    public static byte[] compressPicturesOutByte(InputStream input, String suffix, Integer width, Integer height) {
        ByteArrayOutputStream byteArrayOutputStream = ImagesUtil.compressPicturesOutStream(input, suffix, width, height);
        return byteArrayOutputStream == null ? null : byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream compressPicturesOutStream(InputStream input, String suffix, Integer width, Integer height) {
        if (input == null) {
            log.error("\u56fe\u7247\u4e3anull");
            return null;
        }
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        ByteArrayOutputStream outputStream = null;
        try {
            Thumbnails.Builder builder;
            boolean isRatio;
            BufferedImage image = ImageIO.read(input);
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            boolean bl = isRatio = 0.75 != (double)((float)imageWidth / (float)imageHeight);
            if (isRatio) {
                image = imageWidth > imageHeight ? Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).height(height.intValue()).asBufferedImage() : Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).width(width.intValue()).asBufferedImage();
                builder = Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).sourceRegion((Position)Positions.CENTER, width.intValue(), height.intValue()).size(width.intValue(), height.intValue());
            } else {
                builder = Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).size(width.intValue(), height.intValue());
            }
            outputStream = new ByteArrayOutputStream();
            builder.outputFormat(suffix).toOutputStream((OutputStream)outputStream);
            ByteArrayOutputStream byteArrayOutputStream = outputStream;
            IOUtils.closeQuietly((OutputStream)outputStream);
            return byteArrayOutputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u538b\u7f29\u6307\u5b9a\u5bbd\u9ad8\u56fe\u7247\u51fa\u9519:{}", (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(outputStream);
        }
        return null;
    }

    public static byte[] compressNetworkPicturesOutByte(String url, Integer width, Integer height) {
        ByteArrayOutputStream byteArrayOutputStream = ImagesUtil.compressNetworkPicturesOutStream(url, width, height);
        return byteArrayOutputStream == null ? null : byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream compressNetworkPicturesOutStream(String url, Integer width, Integer height) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (ReUtil.get((String)"^(http|https|ftp)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]", (CharSequence)url, (int)0) == null) {
            log.error("url\u4e0d\u7b26\u5408\u89c4\u5219");
            return null;
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new URL(url).openStream());
            byteArrayOutputStream = ImagesUtil.compressPicturesOutStream(bufferedInputStream, FileTypeUtil.getType((InputStream)new URL(url).openStream()), Math.max(width, 1), Math.max(height, 1));
        }
        catch (Exception e) {
            ByteArrayOutputStream byteArrayOutputStream2;
            try {
                e.printStackTrace();
                log.error("\u538b\u7f29\u7f51\u7edc\u56fe\u7247\u51fa\u9519:{}", (Object)e.getMessage());
                byteArrayOutputStream2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bufferedInputStream);
            return byteArrayOutputStream2;
        }
        IOUtils.closeQuietly((InputStream)bufferedInputStream);
        return byteArrayOutputStream;
    }

    public static byte[] scaleToScaleOutByte(InputStream imgFile, String suffix, double scaling) {
        ByteArrayOutputStream byteArrayOutputStream = ImagesUtil.scaleToScaleOutStream(imgFile, suffix, scaling);
        return byteArrayOutputStream == null ? null : byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream scaleToScaleOutStream(InputStream imgFile, String suffix, double scaling) {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            Thumbnails.of((InputStream[])new InputStream[]{imgFile}).scale(scaling).outputFormat(suffix).toOutputStream((OutputStream)outputStream);
            ByteArrayOutputStream byteArrayOutputStream = outputStream;
            return byteArrayOutputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u538b\u7f29\u7f51\u7edc\u56fe\u7247\u51fa\u9519:{}", (Object)e.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = null;
            return byteArrayOutputStream;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    public static byte[] scaleToScaleOutByte(InputStream imgFile, String suffix, Integer width, Integer height, boolean isScaling) {
        ByteArrayOutputStream byteArrayOutputStream = ImagesUtil.scaleToScaleOutStream(imgFile, suffix, width, height, isScaling);
        return byteArrayOutputStream == null ? null : byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream scaleToScaleOutStream(InputStream imgFile, String suffix, Integer width, Integer height, boolean isScaling) {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            Thumbnails.of((InputStream[])new InputStream[]{imgFile}).size(width.intValue(), height.intValue()).keepAspectRatio(isScaling).outputFormat(suffix).toOutputStream((OutputStream)outputStream);
            ByteArrayOutputStream byteArrayOutputStream = outputStream;
            return byteArrayOutputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u4e0d\u6309\u7167\u6bd4\u4f8b\u7f29\u653e\u56fe\u7247\u51fa\u9519:{}", (Object)e.getMessage());
            ByteArrayOutputStream byteArrayOutputStream = null;
            return byteArrayOutputStream;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    public static byte[] compressionSizeOutByte(InputStream imgFile, String suffix, double compressionRatio, double scaling) {
        ByteArrayOutputStream byteArrayOutputStream = ImagesUtil.compressionSizeOutStream(imgFile, suffix, compressionRatio, scaling);
        return byteArrayOutputStream == null ? null : byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream compressionSizeOutStream(InputStream imgFile, String suffix, double compressionRatio, double scaling) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream outputStream = null;
        try {
            compressionRatio = Math.max(compressionRatio, 0.0);
            scaling = Math.min(1.0, Math.max(scaling, 0.0));
            outputStream = new ByteArrayOutputStream();
            Thumbnails.of((InputStream[])new InputStream[]{imgFile}).scale(compressionRatio).outputQuality(scaling).outputFormat(suffix).toOutputStream((OutputStream)outputStream);
            byteArrayOutputStream = outputStream;
        }
        catch (IOException e) {
            ByteArrayOutputStream byteArrayOutputStream2;
            try {
                e.printStackTrace();
                log.error("\u538b\u7f29\u56fe\u7247\u5927\u5c0f\u56fe\u7247\u5c3a\u5bf8\u4e0d\u53d8\u51fa\u9519:{}", (Object)e.getMessage());
                byteArrayOutputStream2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            return byteArrayOutputStream2;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return byteArrayOutputStream;
    }

    public static boolean backgroundRemoval(String inputPath, String outputPath, int tolerance) {
        return ImagesUtil.backgroundRemoval(new File(inputPath), new File(outputPath), tolerance);
    }

    public static boolean backgroundRemoval(File input, File output, int tolerance) {
        return ImagesUtil.backgroundRemoval(input, output, null, tolerance);
    }

    public static boolean backgroundRemoval(File input, File output, Color override, int tolerance) {
        if (ImagesUtil.fileTypeValidation(input, IMAGES_TYPE)) {
            return false;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(input);
            return ImageIO.write((RenderedImage)ImagesUtil.backgroundRemoval(bufferedImage, override, tolerance), "png", output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static BufferedImage backgroundRemoval(BufferedImage bufferedImage, Color override, int tolerance) {
        tolerance = Math.min(255, Math.max(tolerance, 0));
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        BufferedImage image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
        Graphics graphics = image.getGraphics();
        graphics.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        Object[] removeRgb = ImagesUtil.getRemoveRgb(bufferedImage);
        String mainColor = ImagesUtil.getMainColor(bufferedImage);
        int alpha = 0;
        for (int y = image.getMinY(); y < image.getHeight(); ++y) {
            for (int x = image.getMinX(); x < image.getWidth(); ++x) {
                boolean isTrue;
                int rgb = image.getRGB(x, y);
                String hex = ImagesUtil.rgbToHex((rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF);
                boolean bl = isTrue = ArrayUtil.contains((Object[])removeRgb, (Object)hex) || ImagesUtil.areColorsWithinTolerance(ImagesUtil.hexToRgb(mainColor), new Color(Integer.parseInt(hex.substring(1), 16)), tolerance);
                if (isTrue) {
                    rgb = override == null ? alpha + 1 << 24 | rgb & 0xFFFFFF : override.getRGB();
                }
                image.setRGB(x, y, rgb);
            }
        }
        graphics.drawImage(image, 0, 0, imageIcon.getImageObserver());
        return image;
    }

    public static BufferedImage backgroundRemoval(ByteArrayOutputStream outputStream, Color override, int tolerance) {
        try {
            return ImagesUtil.backgroundRemoval(ImageIO.read(new ByteArrayInputStream(outputStream.toByteArray())), override, tolerance);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String[] getRemoveRgb(BufferedImage image) {
        int width = image.getWidth() - 1;
        int height = image.getHeight() - 1;
        int leftUpPixel = image.getRGB(1, 1);
        String leftUp = ImagesUtil.rgbToHex((leftUpPixel & 0xFF0000) >> 16, (leftUpPixel & 0xFF00) >> 8, leftUpPixel & 0xFF);
        int upMiddlePixel = image.getRGB(width / 2, 1);
        String upMiddle = ImagesUtil.rgbToHex((upMiddlePixel & 0xFF0000) >> 16, (upMiddlePixel & 0xFF00) >> 8, upMiddlePixel & 0xFF);
        int rightUpPixel = image.getRGB(width, 1);
        String rightUp = ImagesUtil.rgbToHex((rightUpPixel & 0xFF0000) >> 16, (rightUpPixel & 0xFF00) >> 8, rightUpPixel & 0xFF);
        int rightMiddlePixel = image.getRGB(width, height / 2);
        String rightMiddle = ImagesUtil.rgbToHex((rightMiddlePixel & 0xFF0000) >> 16, (rightMiddlePixel & 0xFF00) >> 8, rightMiddlePixel & 0xFF);
        int lowerRightPixel = image.getRGB(width, height);
        String lowerRight = ImagesUtil.rgbToHex((lowerRightPixel & 0xFF0000) >> 16, (lowerRightPixel & 0xFF00) >> 8, lowerRightPixel & 0xFF);
        int lowerMiddlePixel = image.getRGB(width / 2, height);
        String lowerMiddle = ImagesUtil.rgbToHex((lowerMiddlePixel & 0xFF0000) >> 16, (lowerMiddlePixel & 0xFF00) >> 8, lowerMiddlePixel & 0xFF);
        int leftLowerPixel = image.getRGB(1, height);
        String leftLower = ImagesUtil.rgbToHex((leftLowerPixel & 0xFF0000) >> 16, (leftLowerPixel & 0xFF00) >> 8, leftLowerPixel & 0xFF);
        int leftMiddlePixel = image.getRGB(1, height / 2);
        String leftMiddle = ImagesUtil.rgbToHex((leftMiddlePixel & 0xFF0000) >> 16, (leftMiddlePixel & 0xFF00) >> 8, leftMiddlePixel & 0xFF);
        return new String[]{leftUp, upMiddle, rightUp, rightMiddle, lowerRight, lowerMiddle, leftLower, leftMiddle};
    }

    public static String rgbToHex(int r, int g, int b) {
        boolean isRgb;
        boolean bl = isRgb = 0 <= r && r <= 255 && 0 <= g && g <= 255 && 0 <= b && b <= 255;
        if (isRgb) {
            return String.format("#%02X%02X%02X", r, g, b);
        }
        log.error("RGB\u989c\u8272\u503c\u53ea\u80fd\u4e3a0~255\u4e4b\u95f4\u7684\u6574\u6570");
        return "";
    }

    public static Color hexToRgb(String hex) {
        return new Color(Integer.parseInt(hex.substring(1), 16));
    }

    public static boolean areColorsWithinTolerance(Color color1, Color color2, int tolerance) {
        return ImagesUtil.areColorsWithinTolerance(color1, color2, new Color(tolerance, tolerance, tolerance));
    }

    public static boolean areColorsWithinTolerance(Color color1, Color color2, Color tolerance) {
        return color1.getRed() - color2.getRed() < tolerance.getRed() && color1.getRed() - color2.getRed() > -tolerance.getRed() && color1.getBlue() - color2.getBlue() < tolerance.getBlue() && color1.getBlue() - color2.getBlue() > -tolerance.getBlue() && color1.getGreen() - color2.getGreen() < tolerance.getGreen() && color1.getGreen() - color2.getGreen() > -tolerance.getGreen();
    }

    public static String getMainColor(String input) {
        return ImagesUtil.getMainColor(new File(input));
    }

    public static String getMainColor(File input) {
        try {
            return ImagesUtil.getMainColor(ImageIO.read(input));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getMainColor(BufferedImage bufferedImage) {
        int rgbLength;
        if (bufferedImage == null) {
            log.error("\u56fe\u7247\u6d41\u662f\u7a7a\u7684");
            return "";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int y = bufferedImage.getMinY(); y < bufferedImage.getHeight(); ++y) {
            for (int x = bufferedImage.getMinX(); x < bufferedImage.getWidth(); ++x) {
                int pixel = bufferedImage.getRGB(x, y);
                list.add(((pixel & 0xFF0000) >> 16) + "-" + ((pixel & 0xFF00) >> 8) + "-" + (pixel & 0xFF));
            }
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(list.size());
        for (String string : list) {
            Integer integer = (Integer)map.get(string);
            if (integer == null) {
                integer = 1;
            } else {
                Integer n = integer;
                Integer n2 = integer = Integer.valueOf(integer + 1);
            }
            map.put(string, integer);
        }
        String max = "";
        long num = 0L;
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Integer temp = (Integer)entry.getValue();
            if (!StringUtils.isBlank((String)max) && (long)temp.intValue() <= num) continue;
            max = key;
            num = temp.intValue();
        }
        String[] strings = max.split("-");
        if (strings.length == (rgbLength = 3)) {
            return ImagesUtil.rgbToHex(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]), Integer.parseInt(strings[2]));
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage cutPictureOutStream(File input, Integer x, Integer y, Integer width, Integer height) {
        if (ImagesUtil.fileTypeValidation(input, IMAGES_TYPE)) {
            return null;
        }
        x = Math.max(x, 0);
        y = Math.max(y, 0);
        width = Math.max(width, 0);
        height = Math.max(height, 0);
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(FileTypeUtil.getType((File)input));
        ImageReader reader = readers.next();
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(new FileInputStream(input));){
            reader.setInput(imageInputStream, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Rectangle rectangle = new Rectangle(x, y, width, height);
            param.setSourceRegion(rectangle);
            BufferedImage bufferedImage = reader.read(0, param);
            return bufferedImage;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] cutPictureOutByte(File input, Integer x, Integer y, Integer width, Integer height) {
        BufferedImage bufferedImage = ImagesUtil.cutPictureOutStream(input, x, y, width, height);
        if (bufferedImage == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bufferedImage, FileTypeUtil.getType((File)input), out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean cutPictureOutFile(File input, File output, Integer x, Integer y, Integer width, Integer height) {
        BufferedImage bufferedImage = ImagesUtil.cutPictureOutStream(input, x, y, width, height);
        if (bufferedImage == null) {
            return false;
        }
        try {
            return ImageIO.write((RenderedImage)bufferedImage, FileTypeUtil.getType((File)input), output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static BufferedImage mergeOutStream(File[] files, boolean horizontalOrVertical) {
        boolean judgeWidthAndHeight;
        boolean eligible = false;
        for (File file : files) {
            eligible = ImagesUtil.fileTypeValidation(file, IMAGES_TYPE);
        }
        if (eligible) {
            return null;
        }
        BufferedImage[] images = new BufferedImage[files.length];
        int[][] imageArrays = new int[files.length][];
        for (int i = 0; i < files.length; ++i) {
            try {
                images[i] = ImageIO.read(files[i]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            int width = images[i].getWidth();
            int height = images[i].getHeight();
            imageArrays[i] = new int[width * height];
            imageArrays[i] = images[i].getRGB(0, 0, width, height, imageArrays[i], 0, width);
        }
        int newHeight = 0;
        int newWidth = 0;
        for (BufferedImage image : images) {
            if (horizontalOrVertical) {
                newHeight = Math.max(newHeight, image.getHeight());
                newWidth += image.getWidth();
                continue;
            }
            newWidth = Math.max(newWidth, image.getWidth());
            newHeight += image.getHeight();
        }
        boolean bl = judgeWidthAndHeight = horizontalOrVertical && newWidth < 1 || !horizontalOrVertical && newHeight < 1;
        if (judgeWidthAndHeight) {
            return null;
        }
        BufferedImage newPictureStream = new BufferedImage(newWidth, newHeight, 1);
        int height = 0;
        int width = 0;
        for (int i = 0; i < images.length; ++i) {
            if (horizontalOrVertical) {
                newPictureStream.setRGB(width, 0, images[i].getWidth(), newHeight, imageArrays[i], 0, images[i].getWidth());
                width += images[i].getWidth();
                continue;
            }
            newPictureStream.setRGB(0, height, newWidth, images[i].getHeight(), imageArrays[i], 0, newWidth);
            height += images[i].getHeight();
        }
        return newPictureStream;
    }

    public static BufferedImage mergeOutStream(String[] files, boolean horizontalOrVertical) {
        return ImagesUtil.mergeOutStream(ImagesUtil.arrayTypeConversion(files), horizontalOrVertical);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] mergeOutByte(File[] files, boolean horizontalOrVertical) {
        BufferedImage bufferedImage = ImagesUtil.mergeOutStream(files, horizontalOrVertical);
        if (bufferedImage == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bufferedImage, FileTypeUtil.getType((File)files[0]), out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] mergeOutByte(String[] files, boolean horizontalOrVertical) {
        return ImagesUtil.mergeOutByte(ImagesUtil.arrayTypeConversion(files), horizontalOrVertical);
    }

    public static boolean mergeOutFile(File[] files, File output, boolean horizontalOrVertical) {
        BufferedImage bufferedImage = ImagesUtil.mergeOutStream(files, horizontalOrVertical);
        if (bufferedImage == null) {
            return false;
        }
        try {
            return ImageIO.write((RenderedImage)bufferedImage, FileTypeUtil.getType((File)files[0]), output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean mergeOutFile(String[] files, String output, boolean horizontalOrVertical) {
        return ImagesUtil.mergeOutFile(ImagesUtil.arrayTypeConversion(files), new File(output), horizontalOrVertical);
    }

    private static boolean fileTypeValidation(File input, String[] imagesType) {
        if (!input.exists()) {
            log.error("\u7ed9\u5b9a\u6587\u4ef6\u4e3a\u7a7a");
            return true;
        }
        String type = FileTypeUtil.getType((File)input);
        if (!ArrayUtil.contains((Object[])imagesType, (Object)type)) {
            log.error("\u6587\u4ef6\u7c7b\u578b{}\u4e0d\u652f\u6301", (Object)type);
            return true;
        }
        return false;
    }

    private static File[] arrayTypeConversion(String[] files) {
        File[] fileArray = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            fileArray[i] = new File(files[i]);
        }
        return fileArray;
    }
}

