/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.utils;

import cn.novelweb.tool.upload.fastdfs.exception.FastDfsColumnMapException;
import cn.novelweb.tool.upload.fastdfs.mapper.FieldMateData;
import cn.novelweb.tool.upload.fastdfs.mapper.ObjectMateData;
import cn.novelweb.tool.upload.fastdfs.utils.Log;
import cn.novelweb.tool.upload.fastdfs.utils.ReflectionsUtils;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastDfsParamMapperUtils {
    private static final Logger log = LoggerFactory.getLogger(FastDfsParamMapperUtils.class);
    private static Map<String, ObjectMateData> mapCache = new HashMap<String, ObjectMateData>();

    private FastDfsParamMapperUtils() {
    }

    public static <T> T map(byte[] content, Class<T> genericType, Charset charset) {
        ObjectMateData objectMap = FastDfsParamMapperUtils.getObjectMap(genericType);
        if (log.isDebugEnabled()) {
            objectMap.dumpObjectMateData();
        }
        try {
            return FastDfsParamMapperUtils.mapByIndex(content, genericType, objectMap, charset);
        }
        catch (InstantiationException ie) {
            Log.debug("Cannot instantiate: ", ie);
            throw new FastDfsColumnMapException(ie);
        }
        catch (IllegalAccessException iae) {
            Log.debug("Illegal access: ", iae);
            throw new FastDfsColumnMapException(iae);
        }
        catch (InvocationTargetException ite) {
            Log.debug("Cannot invoke method: ", ite);
            throw new FastDfsColumnMapException(ite);
        }
    }

    public static <T> ObjectMateData getObjectMap(Class<T> genericType) {
        if (null == mapCache.get(genericType.getName())) {
            mapCache.put(genericType.getName(), new ObjectMateData(genericType));
        }
        return mapCache.get(genericType.getName());
    }

    private static <T> T mapByIndex(byte[] content, Class<T> genericType, ObjectMateData objectMap, Charset charset) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        List<FieldMateData> mappingFields = objectMap.getFieldList();
        T obj = genericType.newInstance();
        for (FieldMateData field : mappingFields) {
            if (log.isTraceEnabled()) {
                log.trace("\u8bbe\u7f6e\u503c\u662f " + field + field.getValue(content, charset));
            }
            ReflectionsUtils.setFieldValue(obj, field.getFieldName(), field.getValue(content, charset));
        }
        return obj;
    }

    public static byte[] toByte(Object object, Charset charset) {
        ObjectMateData objectMap = FastDfsParamMapperUtils.getObjectMap(object.getClass());
        try {
            return FastDfsParamMapperUtils.convertFieldToByte(objectMap, object, charset);
        }
        catch (NoSuchMethodException ie) {
            Log.debug("Cannot invoke get methed: ", ie);
            throw new FastDfsColumnMapException(ie);
        }
        catch (IllegalAccessException iae) {
            Log.debug("Illegal access: ", iae);
            throw new FastDfsColumnMapException(iae);
        }
        catch (InvocationTargetException ite) {
            Log.debug("Cannot invoke method: ", ite);
            throw new FastDfsColumnMapException(ite);
        }
    }

    private static byte[] convertFieldToByte(ObjectMateData objectMap, Object object, Charset charset) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        List<FieldMateData> mappingFields = objectMap.getFieldList();
        int size = objectMap.getFieldsSendTotalByteSize(object, charset);
        byte[] result = new byte[size];
        int offSize = 0;
        for (FieldMateData field : mappingFields) {
            byte[] fieldByte = field.toByte(object, charset);
            if (null == fieldByte) continue;
            System.arraycopy(fieldByte, 0, result, offSize, fieldByte.length);
            offSize += fieldByte.length;
        }
        return result;
    }
}

