/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.protocol.tracker.response;

import cn.novelweb.tool.upload.fastdfs.mapper.ObjectMateData;
import cn.novelweb.tool.upload.fastdfs.model.StorageState;
import cn.novelweb.tool.upload.fastdfs.protocol.BaseResponse;
import cn.novelweb.tool.upload.fastdfs.utils.FastDfsParamMapperUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class GetListStorageResponse
extends BaseResponse<List<StorageState>> {
    @Override
    public List<StorageState> decodeContent(InputStream in, Charset charset) throws IOException {
        byte[] bytes = new byte[(int)this.getContentLength()];
        int contentSize = in.read(bytes);
        if ((long)contentSize != this.getContentLength()) {
            throw new IOException("\u8bfb\u53d6\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e0e\u534f\u8bae\u957f\u5ea6\u4e0d\u7b26");
        }
        return this.decodeGroup(bytes, charset);
    }

    private List<StorageState> decodeGroup(byte[] bs, Charset charset) throws IOException {
        ObjectMateData objectMateData = FastDfsParamMapperUtils.getObjectMap(StorageState.class);
        int fixFieldsTotalSize = objectMateData.getFieldsFixTotalSize();
        if (bs.length % fixFieldsTotalSize != 0) {
            throw new IOException("FixFieldsTotalSize=" + fixFieldsTotalSize + ", \u4f46\u662f\u6570\u636e\u957f\u5ea6=" + bs.length + ", \u6570\u636e\u65e0\u6548");
        }
        int count = bs.length / fixFieldsTotalSize;
        int offset = 0;
        ArrayList<StorageState> results = new ArrayList<StorageState>(count);
        for (int i = 0; i < count; ++i) {
            byte[] one = new byte[fixFieldsTotalSize];
            System.arraycopy(bs, offset, one, 0, fixFieldsTotalSize);
            results.add(FastDfsParamMapperUtils.map(one, StorageState.class, charset));
            offset += fixFieldsTotalSize;
        }
        return results;
    }
}

