/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.protocol.storage.request;

import cn.novelweb.tool.upload.fastdfs.mapper.DynamicFieldType;
import cn.novelweb.tool.upload.fastdfs.mapper.FastDfsColumn;
import cn.novelweb.tool.upload.fastdfs.protocol.BaseRequest;
import cn.novelweb.tool.upload.fastdfs.protocol.ProtocolHead;
import java.io.InputStream;
import java.nio.charset.Charset;

public class AppendFileRequest
extends BaseRequest {
    @FastDfsColumn(index=0)
    private long pathSize;
    @FastDfsColumn(index=1)
    private long fileSize;
    @FastDfsColumn(index=2, dynamicField=DynamicFieldType.allRestByte)
    private String path;

    public AppendFileRequest(InputStream inputStream, long fileSize, String path) {
        this.inputFile = inputStream;
        this.fileSize = fileSize;
        this.path = path;
        this.head = new ProtocolHead(24);
    }

    @Override
    public byte[] encodeParam(Charset charset) {
        this.pathSize = this.path.getBytes(charset).length;
        return super.encodeParam(charset);
    }

    public long getPathSize() {
        return this.pathSize;
    }

    public void setPathSize(long pathSize) {
        this.pathSize = pathSize;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    public String toString() {
        return "AppendFileRequest [pathSize=" + this.pathSize + ", fileSize=" + this.fileSize + ", path=" + this.path + "]";
    }
}

