/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.mapper;

import cn.novelweb.tool.upload.fastdfs.exception.FastDfsColumnMapException;
import cn.novelweb.tool.upload.fastdfs.mapper.FastDfsColumn;
import cn.novelweb.tool.upload.fastdfs.mapper.FieldMateData;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectMateData {
    private static final Logger log = LoggerFactory.getLogger(ObjectMateData.class);
    private String className;
    private List<FieldMateData> fieldList;
    private List<FieldMateData> dynamicFieldList = new ArrayList<FieldMateData>();
    private int fieldsTotalSize = 0;

    public <T> ObjectMateData(Class<T> genericType) {
        this.className = genericType.getName();
        this.fieldList = this.praseFieldList(genericType);
        this.validateFieldListDefine();
    }

    private <T> List<FieldMateData> praseFieldList(Class<T> genericType) {
        Field[] fields = genericType.getDeclaredFields();
        ArrayList<FieldMateData> mateData = new ArrayList<FieldMateData>();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(FastDfsColumn.class)) continue;
            FieldMateData fieldMateData = new FieldMateData(field, this.fieldsTotalSize);
            mateData.add(fieldMateData);
            this.fieldsTotalSize += fieldMateData.getRealSize();
            if (!fieldMateData.isDynamicField()) continue;
            this.dynamicFieldList.add(fieldMateData);
        }
        return mateData;
    }

    private void validateFieldListDefine() {
        for (FieldMateData field : this.fieldList) {
            this.validateFieldItemDefineByIndex(field);
        }
    }

    private void validateFieldItemDefineByIndex(FieldMateData field) {
        for (FieldMateData fieldMateData : this.fieldList) {
            if (field.equals(fieldMateData) || field.getIndex() != fieldMateData.getIndex()) continue;
            Object[] param = new Object[]{this.className, field.getFieldName(), fieldMateData.getFieldName(), field.getIndex()};
            log.warn("\u5728\u7c7b{}\u6620\u5c04\u5b9a\u4e49\u4e2d{}\u4e0e{}\u7d22\u5f15\u5b9a\u4e49\u76f8\u540c\u4e3a{}(\u8bf7\u68c0\u67e5\u662f\u5426\u4e3a\u7a0b\u5e8f\u9519\u8bef)", param);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public List<FieldMateData> getFieldList() {
        return Collections.unmodifiableList(this.fieldList);
    }

    private boolean hasDynamicField() {
        for (FieldMateData field : this.fieldList) {
            if (!field.isDynamicField()) continue;
            return true;
        }
        return false;
    }

    private int getDynamicFieldSize(Object obj, Charset charset) {
        int size = 0;
        for (FieldMateData field : this.dynamicFieldList) {
            size += field.getDynamicFieldByteSize(obj, charset);
        }
        return size;
    }

    public int getFieldsFixTotalSize() {
        if (this.hasDynamicField()) {
            throw new FastDfsColumnMapException(this.className + "\u7c7b\u4e2d\u6709Dynamic\u5b57\u6bb5, \u4e0d\u652f\u6301\u64cd\u4f5cgetFieldsTotalSize");
        }
        return this.fieldsTotalSize;
    }

    public int getFieldsSendTotalByteSize(Object bean, Charset charset) {
        if (!this.hasDynamicField()) {
            return this.fieldsTotalSize;
        }
        int dynamicFieldSize = this.getDynamicFieldSize(bean, charset);
        return this.fieldsTotalSize + dynamicFieldSize;
    }

    public void dumpObjectMateData() {
        if (log.isTraceEnabled()) {
            log.trace("#----------------------------------------------------------------------------------------------------------------------------------");
            log.trace("# dump class={}", (Object)this.className);
            log.trace("#----------------------------------------------------------------------------------------------------------------------------------");
            for (FieldMateData md : this.fieldList) {
                log.trace(md.toString());
            }
        }
    }
}

