/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.client;

import cn.novelweb.tool.upload.fastdfs.client.TrackerClient;
import cn.novelweb.tool.upload.fastdfs.conn.CommandExecutor;
import cn.novelweb.tool.upload.fastdfs.exception.FastDfsException;
import cn.novelweb.tool.upload.fastdfs.model.GroupState;
import cn.novelweb.tool.upload.fastdfs.model.StorageNode;
import cn.novelweb.tool.upload.fastdfs.model.StorageNodeInfo;
import cn.novelweb.tool.upload.fastdfs.model.StorageState;
import cn.novelweb.tool.upload.fastdfs.protocol.tracker.DeleteStorageCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.tracker.GetFetchStorageCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.tracker.GetGroupListCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.tracker.GetStorageListCommandAbstract;
import cn.novelweb.tool.upload.fastdfs.protocol.tracker.GetStorageNodeCommandAbstract;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTrackerClient
implements TrackerClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultTrackerClient.class);
    private CommandExecutor commandExecutor;

    public DefaultTrackerClient(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public StorageNode getStorageNode() {
        GetStorageNodeCommandAbstract command = new GetStorageNodeCommandAbstract();
        return this.commandExecutor.execute(command);
    }

    @Override
    public StorageNode getStorageNode(String groupName) {
        StorageNode storageNode = null;
        GetStorageNodeCommandAbstract command = new GetStorageNodeCommandAbstract(groupName);
        try {
            storageNode = this.commandExecutor.execute(command);
        }
        catch (FastDfsException e) {
            log.error("\u5b58\u50a8\u8282\u70b9\u4e0d\u5b58\u5728 groupName=[" + groupName + "]", (Throwable)e);
        }
        return storageNode;
    }

    @Override
    public StorageNodeInfo getFetchStorage(String groupName, String filename) {
        GetFetchStorageCommandAbstract command = new GetFetchStorageCommandAbstract(groupName, filename, false);
        return this.commandExecutor.execute(command);
    }

    @Override
    public StorageNodeInfo getFetchStorageAndUpdate(String groupName, String filename) {
        GetFetchStorageCommandAbstract command = new GetFetchStorageCommandAbstract(groupName, filename, true);
        return this.commandExecutor.execute(command);
    }

    @Override
    public List<GroupState> getGroupStates() {
        GetGroupListCommandAbstract command = new GetGroupListCommandAbstract();
        ArrayList result = this.commandExecutor.execute(command);
        return result != null ? result : new ArrayList();
    }

    @Override
    public List<StorageState> getStorageStates(String groupName) {
        GetStorageListCommandAbstract command = new GetStorageListCommandAbstract(groupName);
        ArrayList result = this.commandExecutor.execute(command);
        return result != null ? result : new ArrayList();
    }

    @Override
    public StorageState getStorageState(String groupName, String storageIp) {
        GetStorageListCommandAbstract command = new GetStorageListCommandAbstract(groupName, storageIp);
        List<StorageState> result = this.commandExecutor.execute(command);
        if (result != null && result.size() > 1) {
            log.warn("\u5e94\u8be5\u8fd4\u56de\u4e00\u6761\u6570\u636e, \u4f46\u662f\u73b0\u5728\u8fd4\u56de\u4e86{}\u6761, \u53ea\u53d6\u7b2c\u4e00\u6761", (Object)result.size());
        }
        return result != null && result.size() >= 1 ? result.get(0) : null;
    }

    @Override
    public boolean deleteStorage(String groupName, String storageIp) {
        DeleteStorageCommandAbstract command = new DeleteStorageCommandAbstract(groupName, storageIp);
        try {
            this.commandExecutor.execute(command);
        }
        catch (Throwable e) {
            log.error("\u8e22\u51fa\u5b58\u50a8\u670d\u52a1\u5668\u5931\u8d25, groupName=[" + groupName + "], storageIp=[" + storageIp + "]", e);
            return false;
        }
        return true;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }
}

