/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.send.message.aliyuncs;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.novelweb.tool.send.message.aliyuncs.AliYunSmsConfig;
import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Encoder;

public class AliYunSignature {
    public static JSONObject getAliYunSmsSignature(final String phone, final String templateCode, final String outId, final String smsUpExtendCode, final JSONObject templateParam, final AliYunSmsConfig aliYunSmsConfig) {
        Map<String, String> parameters = new TreeMap<String, String>(){
            {
                this.put("SignatureMethod", aliYunSmsConfig.getSignatureMethod());
                this.put("SignatureNonce", aliYunSmsConfig.getSignatureNonce());
                this.put("AccessKeyId", aliYunSmsConfig.getAccessKeyId());
                this.put("SignatureVersion", aliYunSmsConfig.getSignatureVersion());
                this.put("Timestamp", aliYunSmsConfig.getTimestamp());
                this.put("Format", aliYunSmsConfig.getFormat().getFormat());
                this.put("Action", aliYunSmsConfig.getAction());
                this.put("Version", aliYunSmsConfig.getVersion());
                this.put("RegionId", aliYunSmsConfig.getRegionId());
                this.put("PhoneNumbers", phone);
                this.put("SignName", aliYunSmsConfig.getSignName());
                this.put("TemplateCode", templateCode);
                this.put("TemplateParam", templateParam.toJSONString());
                this.put("OutId", outId);
                this.put("SmsUpExtendCode", smsUpExtendCode);
            }
        };
        parameters = MapUtil.filter((Map)parameters, o -> StrUtil.isNotBlank((CharSequence)((CharSequence)o.getValue())));
        try {
            Iterator<String> it = parameters.keySet().iterator();
            StringBuilder sortQueryStringTmp = new StringBuilder();
            while (it.hasNext()) {
                String key = it.next();
                sortQueryStringTmp.append("&").append(AliYunSignature.specialUrlEncode(key)).append("=").append(AliYunSignature.specialUrlEncode(parameters.get(key)));
            }
            String stringToSign = "GET&" + AliYunSignature.specialUrlEncode("/") + "&" + AliYunSignature.specialUrlEncode(sortQueryStringTmp.substring(1));
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(StrUtil.format((CharSequence)"{}&", (Object[])new Object[]{aliYunSmsConfig.getAccessKeySecret()}).getBytes(StandardCharsets.UTF_8), "HmacSHA1"));
            byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            String sign = new BASE64Encoder().encode(signData);
            String signature = AliYunSignature.specialUrlEncode(sign);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("signature", (Object)signature);
            jsonObject.put("parameters", (Object)sortQueryStringTmp);
            jsonObject.put("requestUrl", (Object)StrUtil.format((CharSequence)"http://{}/?Signature={}{}", (Object[])new Object[]{aliYunSmsConfig.getDomain().getDomain(), signature, sortQueryStringTmp}));
            return jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JSONObject();
        }
    }

    private static String specialUrlEncode(String value) throws Exception {
        return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }
}

