/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.send.message;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.novelweb.tool.send.message.aliyuncs.AliYunSignature;
import cn.novelweb.tool.send.message.aliyuncs.AliYunSmsConfig;
import cn.novelweb.tool.send.message.aliyuncs.AliYunSmsConfigAbbreviations;
import cn.novelweb.tool.send.message.qcloudsms.TencentCloudSmsConfig;
import com.alibaba.fastjson.JSONObject;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsUtil {
    private static final Logger log = LoggerFactory.getLogger(SmsUtil.class);

    public static String aliYunSendSms(AliYunSmsConfig aliYunSmsConfig, String phone, String templateCode, String outId, String smsUpExtendCode, JSONObject templateParam) {
        Assert.isTrue((boolean)Validator.isMobile((CharSequence)phone), (String)"\u624b\u673a\u53f7\u4e0d\u6b63\u786e", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)templateCode, (String)"\u77ed\u4fe1\u6a21\u677fid\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)aliYunSmsConfig, (String)"\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        aliYunSmsConfig.setAction("SendSms");
        JSONObject aliYunSignature = AliYunSignature.getAliYunSmsSignature(phone, templateCode, outId, smsUpExtendCode, templateParam, aliYunSmsConfig);
        Assert.isFalse((boolean)aliYunSignature.isEmpty(), (String)"\u83b7\u53d6\u77ed\u4fe1\u7b7e\u540d\u5931\u8d25", (Object[])new Object[0]);
        return HttpRequest.get((String)aliYunSignature.getString("requestUrl")).timeout(-1).execute().body();
    }

    public static String aliYunSendSms(AliYunSmsConfigAbbreviations aliYunSmsConfigAbbreviations) {
        Assert.notNull((Object)aliYunSmsConfigAbbreviations, (String)"\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        AliYunSmsConfig aliYunSmsConfig = AliYunSmsConfig.init();
        aliYunSmsConfig.setAccessKeyId(aliYunSmsConfigAbbreviations.getAccessKeyId());
        aliYunSmsConfig.setAccessKeySecret(aliYunSmsConfigAbbreviations.getAccessKeySecret());
        aliYunSmsConfig.setSignName(aliYunSmsConfigAbbreviations.getSignName());
        return SmsUtil.aliYunSendSms(aliYunSmsConfig, aliYunSmsConfigAbbreviations.getPhone(), aliYunSmsConfigAbbreviations.getTemplateCode(), aliYunSmsConfigAbbreviations.getOutId(), null, aliYunSmsConfigAbbreviations.getTemplateParam());
    }

    public static String tencentCloudSendSms(TencentCloudSmsConfig tencentCloudSmsConfig) {
        Assert.notNull((Object)tencentCloudSmsConfig, (String)"\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            long randomNumber = new Random(DateUtil.currentSeconds()).nextLong() % 900000L + 100000L;
            long timeStamp = DateUtil.currentSeconds();
            JSONObject mobile = new JSONObject();
            mobile.put("nationcode", (Object)tencentCloudSmsConfig.getNationCode());
            mobile.put("mobile", (Object)tencentCloudSmsConfig.getPhone());
            JSONObject requestBody = new JSONObject();
            requestBody.put("tel", (Object)mobile);
            requestBody.put("type", (Object)tencentCloudSmsConfig.getType());
            requestBody.put("msg", (Object)tencentCloudSmsConfig.getContent());
            String signature = StrUtil.format((CharSequence)"appkey={}&random={}&time={}&mobile={}", (Object[])new Object[]{tencentCloudSmsConfig.getAppKey(), randomNumber, timeStamp, tencentCloudSmsConfig.getPhone()});
            requestBody.put("sig", (Object)DigestUtils.sha256Hex((String)signature));
            requestBody.put("time", (Object)timeStamp);
            requestBody.put("extend", (Object)tencentCloudSmsConfig.getExtend());
            requestBody.put("ext", (Object)tencentCloudSmsConfig.getExt());
            String url = StrUtil.format((CharSequence)"https://yun.tim.qq.com/v5/tlssmssvr/sendsms?sdkappid={}&random={}", (Object[])new Object[]{tencentCloudSmsConfig.getAppId(), randomNumber});
            return ((HttpRequest)HttpRequest.post((String)url).header("Conetent-Type", "application/json")).body(requestBody.toJSONString()).timeout(-1).execute().body();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            Assert.isFalse((boolean)Boolean.TRUE, (String)"\u6240\u9700\u53c2\u6570\u4e3aNull", (Object[])new Object[0]);
            return "NullPointerException";
        }
    }
}

