/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.io;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.lang.StringUtils;

public class FileUtils {
    public static byte[] toByteArray(String filePath) {
        try {
            return Files.readAllBytes(Paths.get(filePath, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] toByteArray(File file) {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream toInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static OutputStream toOutputStream(File file) {
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void toFile(InputStream inputStream, File destination) {
        try {
            org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)destination);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File write(String filePath, String content, boolean isAppend) {
        FileWriter writer = new FileWriter(filePath);
        return writer.write(content, isAppend);
    }

    public static File write(File file, String content, boolean isAppend) {
        FileWriter writer = new FileWriter(file);
        return writer.write(content, isAppend);
    }

    public static File write(String filePath, String content) {
        FileWriter writer = new FileWriter(filePath);
        return writer.write(content);
    }

    public static File write(File file, String content) {
        FileWriter writer = new FileWriter(file);
        return writer.write(content);
    }

    public static String inputStreamToString(InputStream inputStream) {
        return FileUtils.inputStreamToString(inputStream, "UTF-8");
    }

    public static String inputStreamToString(InputStream inputStream, String charsetName) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            if (StringUtils.isBlank((String)charsetName)) {
                return result.toString("UTF-8");
            }
            return result.toString(charsetName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isWindows() {
        return FileUtil.isWindows();
    }
}

