/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.annotation.log.realize;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.thread.ThreadUtil;
import cn.novelweb.annotation.TaskCallback;
import cn.novelweb.annotation.log.OpLog;
import cn.novelweb.annotation.log.callback.OpLogCompletionHandler;
import cn.novelweb.annotation.log.pojo.OpLogInfo;
import cn.novelweb.annotation.log.util.Annotation;
import com.alibaba.fastjson.JSONObject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class OpLogAspect {
    @Pointcut(value="@annotation(cn.novelweb.annotation.log.OpLog)")
    public void opLog() {
    }

    @AfterReturning(pointcut="opLog()")
    public void doBefore(JoinPoint joinPoint) {
        this.handleLog(joinPoint, null);
    }

    @AfterThrowing(value="opLog()", throwing="e")
    public void doAfter(JoinPoint joinPoint, Exception e) {
        this.handleLog(joinPoint, e);
    }

    private void handleLog(JoinPoint joinPoint, Exception e) {
        OpLog opLog = Annotation.getAnnotation(joinPoint, OpLog.class);
        if (opLog == null) {
            return;
        }
        OpLogInfo opLogInfo = (OpLogInfo)Convert.convert(OpLogInfo.class, (Object)Annotation.initInfo(opLog.title(), opLog.isGetIp(), e));
        opLogInfo.setBusinessType(opLog.businessType());
        opLogInfo.setClassName(joinPoint.getTarget().getClass().getName());
        opLogInfo.setMethodName(joinPoint.getSignature().getName());
        if (opLog.isSaveRequestData()) {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null) {
                opLogInfo.setParameter(JSONObject.toJSONString((Object)requestAttributes.getRequest().getParameterMap()));
            } else {
                opLogInfo.setParameter("\u65e0\u6cd5\u83b7\u53d6request\u4fe1\u606f");
            }
        }
        ThreadUtil.execAsync(() -> TaskCallback.callback(OpLogCompletionHandler.class, opLogInfo));
    }
}

