/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.annotation.log.realize;

import cn.hutool.core.thread.ThreadUtil;
import cn.novelweb.annotation.TaskCallback;
import cn.novelweb.annotation.log.AccessLog;
import cn.novelweb.annotation.log.callback.AccessLogCompletionHandler;
import cn.novelweb.annotation.log.pojo.AccessLogInfo;
import cn.novelweb.annotation.log.util.Annotation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AccessLogAspect {
    @Pointcut(value="@annotation(cn.novelweb.annotation.log.AccessLog)")
    public void accessLog() {
    }

    @AfterReturning(pointcut="accessLog()")
    public void doBefore(JoinPoint joinPoint) {
        this.handleLog(joinPoint, null);
    }

    @AfterThrowing(value="accessLog()", throwing="e")
    public void doAfter(JoinPoint joinPoint, Exception e) {
        this.handleLog(joinPoint, e);
    }

    private void handleLog(JoinPoint joinPoint, Exception e) {
        AccessLog accessLog = Annotation.getAnnotation(joinPoint, AccessLog.class);
        if (accessLog == null) {
            return;
        }
        AccessLogInfo accessLogInfo = Annotation.initInfo(accessLog.title(), accessLog.isGetIp(), e);
        ThreadUtil.execAsync(() -> TaskCallback.callback(AccessLogCompletionHandler.class, accessLogInfo));
    }
}

