/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.annotation;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCallback {
    private static final Logger log = LoggerFactory.getLogger(TaskCallback.class);
    private static Set<Class<?>> packageName;

    public static void callback(Class<?> superClass, Object ... args) {
        if (packageName == null || packageName.isEmpty()) {
            packageName = ClassUtil.scanPackageBySuper((String)"", superClass);
        }
        if (packageName.isEmpty()) {
            log.info("If you want to get processing results, implement the {} interface", (Object)superClass.getName());
            return;
        }
        for (Class<?> name : packageName) {
            ThreadUtil.execAsync(() -> {
                String pk = name.toString().substring(name.toString().indexOf(" ") + 1);
                if (StrUtil.isBlank((CharSequence)pk)) {
                    log.error("Failed to get class name");
                    return;
                }
                Class clazz = ClassLoaderUtil.loadClass((String)pk);
                if (null == clazz) {
                    log.error("Load class with name of [{}] fail !", (Object)pk);
                    return;
                }
                Object obj = ReflectUtil.newInstanceIfPossible((Class)clazz);
                ReflectUtil.invoke((Object)obj, (String)"complete", (Object[])args);
            });
        }
    }
}

