/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.annotation.log.realize;

import cn.hutool.core.thread.ThreadUtil;
import cn.novelweb.annotation.TaskCallback;
import cn.novelweb.annotation.log.AccessLog;
import cn.novelweb.annotation.log.callback.AccessLogCompletionHandler;
import cn.novelweb.annotation.log.pojo.AccessLogInfo;
import cn.novelweb.annotation.log.util.Annotation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AccessLogAspect {
    private static final Logger log = LoggerFactory.getLogger(AccessLogAspect.class);

    @Pointcut(value="@annotation(cn.novelweb.annotation.log.AccessLog)")
    public void accessLog() {
    }

    @AfterReturning(pointcut="accessLog()")
    public void doBefore(JoinPoint joinPoint) {
        try {
            this.handleLog(joinPoint, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterThrowing(value="accessLog()", throwing="e")
    public void doAfter(JoinPoint joinPoint, Exception e) {
        try {
            this.handleLog(joinPoint, e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void handleLog(JoinPoint joinPoint, Exception e) {
        AccessLog accessLog = Annotation.getAnnotation(joinPoint, AccessLog.class);
        if (accessLog == null) {
            log.info("Failed to get the annotation information correctly...");
            return;
        }
        AccessLogInfo accessLogInfo = Annotation.initInfo(accessLog.title(), accessLog.isGetIp(), e);
        ThreadUtil.execAsync(() -> TaskCallback.callback(AccessLogCompletionHandler.class, accessLogInfo));
    }
}

