/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.video.command.util;

import cn.novelweb.video.command.handler.OutHandler;
import cn.novelweb.video.command.handler.OutHandlerMethod;
import cn.novelweb.video.pojo.CommandTask;
import java.io.IOException;

public class ExecUtil {
    public static Process exec(String cmd) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        return runtime.exec(cmd);
    }

    public static boolean stop(Process process) {
        if (process != null) {
            process.destroy();
            return true;
        }
        return false;
    }

    public static void stop(CommandTask task) {
        if (task != null) {
            ExecUtil.stop(task.getProcess());
        }
    }

    public static CommandTask createTask(String taskId, String command, OutHandlerMethod outHandlerMethod) throws IOException {
        Process process = ExecUtil.exec(command);
        OutHandler outHandler = OutHandler.create(process.getErrorStream(), taskId, outHandlerMethod);
        return new CommandTask(taskId, command, process, outHandler);
    }

    public static void restart(CommandTask commandTask) throws IOException {
        if (commandTask != null) {
            String taskId = commandTask.getTaskId();
            String command = commandTask.getCommand();
            OutHandlerMethod outHandlerMethod = null;
            if (commandTask.getThread() != null) {
                outHandlerMethod = commandTask.getThread().getOutHandlerMethod();
            }
            ExecUtil.stop(commandTask);
            Process process = ExecUtil.exec(command);
            commandTask.setProcess(process);
            OutHandler outHandler = OutHandler.create(process.getErrorStream(), taskId, outHandlerMethod);
            commandTask.setThread(outHandler);
        }
    }
}

