/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.video.command.task;

import cn.novelweb.video.command.task.TaskDao;
import cn.novelweb.video.pojo.CommandTask;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TaskDaoImpl
implements TaskDao {
    private ConcurrentMap<String, CommandTask> commandTaskConcurrentMap;

    public TaskDaoImpl(int size) {
        this.commandTaskConcurrentMap = new ConcurrentHashMap<String, CommandTask>(size);
    }

    @Override
    public CommandTask get(String taskId) {
        return (CommandTask)this.commandTaskConcurrentMap.get(taskId);
    }

    @Override
    public Collection<CommandTask> getAll() {
        return this.commandTaskConcurrentMap.values();
    }

    @Override
    public int add(CommandTask commandTask) {
        String id = commandTask.getTaskId();
        if (id != null && !this.commandTaskConcurrentMap.containsKey(id)) {
            this.commandTaskConcurrentMap.put(commandTask.getTaskId(), commandTask);
            if (this.commandTaskConcurrentMap.get(id) != null) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int remove(String taskId) {
        if (this.commandTaskConcurrentMap.remove(taskId) != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int removeAll() {
        int size = this.commandTaskConcurrentMap.size();
        try {
            this.commandTaskConcurrentMap.clear();
        }
        catch (Exception e) {
            return 0;
        }
        return size;
    }

    @Override
    public boolean isHave(String taskId) {
        return this.commandTaskConcurrentMap.containsKey(taskId);
    }
}

