/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.video.command.handler;

import cn.novelweb.tool.upload.fastdfs.utils.Log;
import cn.novelweb.video.command.task.TaskDao;
import cn.novelweb.video.command.util.ExecUtil;
import cn.novelweb.video.pojo.CommandTask;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAliveHandler
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(KeepAliveHandler.class);
    private static Queue<String> queue;
    public int errIndex = 0;
    public volatile int stopIndex = 0;
    private TaskDao taskDao;

    public KeepAliveHandler(TaskDao taskDao) {
        this.taskDao = taskDao;
        queue = new ConcurrentLinkedQueue<String>();
    }

    public static void add(String taskId) {
        if (queue != null) {
            queue.offer(taskId);
        }
    }

    public boolean stop(Process process) {
        if (process != null) {
            process.destroy();
            return true;
        }
        return false;
    }

    @Override
    public void interrupt() {
        this.stopIndex = 1;
    }

    @Override
    public void run() {
        while (this.stopIndex == 0) {
            if (queue == null) continue;
            try {
                while (queue.peek() != null) {
                    Log.debug("\u51c6\u5907\u91cd\u542f\u4efb\u52a1:{}", queue);
                    String taskId = queue.poll();
                    if (this.isInterrupted()) {
                        Log.debug("\u4efb\u52a1id:{},\u7ebf\u7a0b\u5df2\u5173\u95ed", (Object)taskId);
                        return;
                    }
                    CommandTask task = this.taskDao.get(taskId);
                    ExecUtil.restart(task);
                }
            }
            catch (IOException e) {
                Log.debug("\u4efb\u52a1id:{},\u4efb\u52a1\u91cd\u542f\u5931\u8d25", new Object[0]);
                ++this.errIndex;
            }
        }
    }
}

