/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.video.command.handler;

import cn.hutool.core.map.MapUtil;
import cn.novelweb.tool.upload.fastdfs.utils.Log;
import cn.novelweb.video.command.assemble.CommandAssemble;
import cn.novelweb.video.command.assemble.CommandAssembleImpl;
import cn.novelweb.video.command.assemble.CommandBuilder;
import cn.novelweb.video.command.handler.CommandHandler;
import cn.novelweb.video.command.handler.KeepAliveHandler;
import cn.novelweb.video.command.handler.OutHandlerMethod;
import cn.novelweb.video.command.handler.TaskHandler;
import cn.novelweb.video.command.handler.TaskHandlerImpl;
import cn.novelweb.video.command.handler.TaskMessageOutputProcessing;
import cn.novelweb.video.command.task.TaskDao;
import cn.novelweb.video.command.task.TaskDaoImpl;
import cn.novelweb.video.pojo.CommandTask;
import cn.novelweb.video.pojo.ProgramConfig;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CommandHandlerImpl
implements CommandHandler {
    private TaskDao taskDao;
    private TaskHandler taskHandler;
    private CommandAssemble commandAssemble;
    private OutHandlerMethod outHandlerMethod;
    private KeepAliveHandler keepAliveHandler;
    public static ProgramConfig programConfig = new ProgramConfig();

    public CommandHandlerImpl() {
        this(null);
    }

    public CommandHandlerImpl(Integer size) {
        this.init(size);
    }

    public CommandHandlerImpl(TaskDao taskDao, TaskHandler taskHandler, CommandAssemble commandAssemble, OutHandlerMethod outHandlerMethod, Integer size) {
        this.taskDao = taskDao;
        this.taskHandler = taskHandler;
        this.commandAssemble = commandAssemble;
        this.outHandlerMethod = outHandlerMethod;
        this.init(size);
    }

    public void init(Integer size) {
        boolean isKeepalive = false;
        if (size == null) {
            size = programConfig.getSize() == null ? 10 : programConfig.getSize();
            isKeepalive = programConfig.isKeepalive();
        }
        if (this.outHandlerMethod == null) {
            this.outHandlerMethod = new TaskMessageOutputProcessing();
        }
        if (this.taskDao == null) {
            this.taskDao = new TaskDaoImpl(size);
            if (isKeepalive) {
                this.keepAliveHandler = new KeepAliveHandler(this.taskDao);
                this.keepAliveHandler.start();
            }
        }
        if (this.taskHandler == null) {
            this.taskHandler = new TaskHandlerImpl(this.outHandlerMethod);
        }
        if (this.commandAssemble == null) {
            this.commandAssemble = new CommandAssembleImpl();
        }
    }

    @Override
    public void setTaskDao(TaskDao taskDao) {
        this.taskDao = taskDao;
    }

    @Override
    public void setTaskHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
    }

    @Override
    public void setCommandAssemble(CommandAssemble commandAssemble) {
        this.commandAssemble = commandAssemble;
    }

    public boolean isInit(boolean b) {
        boolean ret;
        boolean bl = ret = this.outHandlerMethod == null || this.taskDao == null || this.taskHandler == null || this.commandAssemble == null;
        if (ret && b) {
            this.init(null);
        }
        return ret;
    }

    @Override
    public String start(String taskId, String command) {
        return this.start(taskId, command, false);
    }

    @Override
    public String start(String taskId, String command, boolean hasPath) {
        CommandTask commandTask;
        if (this.isInit(true)) {
            Log.debug("\u6267\u884c\u5931\u8d25,\u672a\u8fdb\u884c\u521d\u59cb\u5316\u6216\u521d\u59cb\u5316\u5931\u8d25!", new Object[0]);
            return null;
        }
        if (taskId != null && command != null && (commandTask = this.taskHandler.process(taskId, hasPath ? command : programConfig.getPath() + " " + command)) != null && !commandTask.getThread().isInterrupted()) {
            int ret = this.taskDao.add(commandTask);
            if (ret > 0) {
                return commandTask.getCommand();
            }
            this.taskHandler.stop(commandTask.getProcess());
            commandTask.getThread().interrupt();
            Log.debug("\u6301\u4e45\u5316\u5931\u8d25,\u505c\u6b62\u4efb\u52a1!", new Object[0]);
        }
        return null;
    }

    @Override
    public String start(String taskId, CommandBuilder commandBuilder) {
        String command = commandBuilder.get();
        if (command != null) {
            return this.start(taskId, command, true);
        }
        return null;
    }

    @Override
    public String start(Map<String, String> map) {
        if (MapUtil.isEmpty(map)) {
            Log.debug("\u53c2\u6570\u4e0d\u6b63\u786e,\u65e0\u6cd5\u6267\u884c", new Object[0]);
            return null;
        }
        String appName = map.get("appName");
        if (StringUtils.isBlank((String)appName)) {
            Log.debug("appName\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
            return null;
        }
        map.put("FFMPEGPath", programConfig.getPath());
        String command = this.commandAssemble.assemble(map);
        if (command != null) {
            return this.start(appName, command, true);
        }
        return null;
    }

    @Override
    public boolean stop(String taskId) {
        if (taskId != null && this.taskDao.isHave(taskId)) {
            Log.debug("\u4efb\u52a1id:{},\u6b63\u5728\u5c1d\u8bd5\u505c\u6b62\u4efb\u52a1", (Object)taskId);
            CommandTask commandTask = this.taskDao.get(taskId);
            commandTask.getThread().interrupt();
            if (this.taskHandler.stop(commandTask.getProcess())) {
                this.taskDao.remove(taskId);
                return true;
            }
        }
        Log.debug("\u4efb\u52a1id:{},\u505c\u6b62\u4efb\u52a1\u5931\u8d25", (Object)taskId);
        return false;
    }

    @Override
    public int stopAll() {
        Collection<CommandTask> list = this.taskDao.getAll();
        Iterator<CommandTask> iter = list.iterator();
        int index = 0;
        while (iter.hasNext()) {
            CommandTask commandTask = iter.next();
            commandTask.getThread().interrupt();
            if (!this.taskHandler.stop(commandTask.getProcess())) continue;
            this.taskDao.remove(commandTask.getTaskId());
            ++index;
        }
        Log.debug("\u5c1d\u8bd5\u505c\u6b62\u4e86{}\u4e2a\u4efb\u52a1", (Object)index);
        return index;
    }

    @Override
    public CommandTask get(String taskId) {
        return this.taskDao.get(taskId);
    }

    @Override
    public Collection<CommandTask> getAll() {
        return this.taskDao.getAll();
    }

    @Override
    public void destroy() {
        if (this.keepAliveHandler != null) {
            this.keepAliveHandler.interrupt();
        }
    }
}

