/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.util;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypes {
    private static final Logger log = LoggerFactory.getLogger(MimeTypes.class);
    private static final String DEFAULT_MIMETYPE = "application/octet-stream";
    private static MimeTypes mimetypes = null;
    private final HashMap<String, String> extensionToMimetypeMap = new HashMap();

    private MimeTypes() {
    }

    public static synchronized MimeTypes getInstance() {
        if (mimetypes != null) {
            return mimetypes;
        }
        mimetypes = new MimeTypes();
        try (InputStream is = mimetypes.getClass().getResourceAsStream("/mime.types");){
            if (is != null) {
                log.debug("Loading mime types from file in the classpath: mime.types");
                mimetypes.loadMimeTypes(is);
            } else {
                log.warn("Unable to find 'mime.types' file in classpath");
            }
        }
        return mimetypes;
    }

    public void loadMimeTypes(InputStream is) {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            StringTokenizer st;
            if ((line = line.trim()).startsWith("#") || line.length() == 0 || (st = new StringTokenizer(line, " \t")).countTokens() <= 1) continue;
            String extension = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String mimetype = st.nextToken();
            this.extensionToMimetypeMap.put(extension.toLowerCase(), mimetype);
        }
    }

    public String getMimeTypes(String fileName) {
        String ext;
        int lastPeriodIndex = fileName.lastIndexOf(".");
        if (lastPeriodIndex > 0 && lastPeriodIndex + 1 < fileName.length() && this.extensionToMimetypeMap.containsKey(ext = fileName.substring(lastPeriodIndex + 1).toLowerCase())) {
            return this.extensionToMimetypeMap.get(ext);
        }
        return DEFAULT_MIMETYPE;
    }

    public String getMimeTypes(File file) {
        if (!file.exists()) {
            return DEFAULT_MIMETYPE;
        }
        String ext = FileTypeUtil.getType((File)file);
        if (StrUtil.isBlank((CharSequence)ext)) {
            return DEFAULT_MIMETYPE;
        }
        if (this.extensionToMimetypeMap.containsKey(ext.toLowerCase())) {
            return this.extensionToMimetypeMap.get(ext.toLowerCase());
        }
        return DEFAULT_MIMETYPE;
    }
}

