/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.qcloud;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.novelweb.tool.upload.qcloud.callback.ListObjectCompletionHandler;
import com.alibaba.fastjson.JSONObject;
import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.MultiObjectDeleteException;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CreateBucketRequest;
import com.qcloud.cos.model.DeleteObjectsRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.Upload;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosUpload {
    private static final Logger log = LoggerFactory.getLogger(CosUpload.class);
    public static String secretId;
    public static String secretKey;
    public static String bucket;
    public static Region regionName;
    public static String[] allowActions;

    public static COSClient initCosClient() {
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig(regionName);
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    public static COSClient initCosClient(ClientConfig clientConfig) {
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    public static Bucket createBucket(String regionName, String bucket, CannedAccessControlList controlList) {
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(regionName));
        COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
        CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucket);
        createBucketRequest.setCannedAcl(controlList);
        return cosClient.createBucket(createBucketRequest);
    }

    public static List<Bucket> getBucketList() {
        COSClient cosClient = CosUpload.initCosClient();
        return cosClient.listBuckets();
    }

    public static List<Bucket> getBucketList(COSClient cosClient) {
        return cosClient.listBuckets();
    }

    public static PutObjectResult mkdir(COSClient cosClient, String key) {
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(0L);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucket, key, (InputStream)input, objectMetadata);
        return cosClient.putObject(putObjectRequest);
    }

    public static PutObjectResult uploader(COSClient cosClient, File file, String key) {
        return cosClient.putObject(bucket, key, file);
    }

    public static PutObjectResult uploader(COSClient cosClient, InputStream cosFile, String key, String contentType) {
        ObjectMetadata objectMetadata = new ObjectMetadata();
        try {
            objectMetadata.setContentLength((long)cosFile.available());
            objectMetadata.setContentType(contentType);
            return cosClient.putObject(bucket, key, cosFile, objectMetadata);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Upload uploader(COSClient cosClient, File file, String key, int threadSize) {
        ExecutorService threadPool = ThreadUtil.newExecutor((int)threadSize);
        TransferManager transferManager = new TransferManager((COS)cosClient, threadPool);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucket, key, file);
        return transferManager.upload(putObjectRequest);
    }

    public static ObjectMetadata download(COSClient cosClient, File file, String key) {
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucket, key);
        return cosClient.getObject(getObjectRequest, file);
    }

    public static boolean delete(COSClient cosClient, String key) {
        return CosUpload.delete(cosClient, key, bucket);
    }

    public static boolean delete(COSClient cosClient, String key, String bucketName) {
        try {
            cosClient.deleteObject(bucketName, key);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean delete(COSClient cosClient, String bucketName, String ... key) {
        if (ArrayUtil.isEmpty((Object[])key)) {
            return false;
        }
        ArrayList<DeleteObjectsRequest.KeyVersion> keyList = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        for (String str : key) {
            keyList.add(new DeleteObjectsRequest.KeyVersion(str));
        }
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName);
        deleteObjectsRequest.setKeys(keyList);
        try {
            cosClient.deleteObjects(deleteObjectsRequest);
            return true;
        }
        catch (MultiObjectDeleteException mde) {
            log.error("\u90e8\u5206\u5220\u9664\u6210\u529f\u90e8\u5206\u5931\u8d25:{}", JSONObject.toJSON((Object)mde.getErrors()));
            log.error("\u5df2\u7ecf\u5220\u9664\u7684key:{}", (Object)mde.getDeletedObjects());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean delete(COSClient cosClient, String ... key) {
        return CosUpload.delete(cosClient, bucket, key);
    }

    public static void getFilesList(COSClient cosClient, String prefix, String delimiter, int maxKeys, ListObjectCompletionHandler handler) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(bucket);
        listObjectsRequest.setPrefix(prefix);
        listObjectsRequest.setDelimiter(delimiter);
        listObjectsRequest.setMaxKeys(Integer.valueOf(maxKeys));
        try {
            ObjectListing objectListing;
            do {
                objectListing = cosClient.listObjects(listObjectsRequest);
                List commonPrefixes = objectListing.getCommonPrefixes();
                List cosObjectSummaries = objectListing.getObjectSummaries();
                String nextMarker = objectListing.getNextMarker();
                listObjectsRequest.setMarker(nextMarker);
                handler.complete(commonPrefixes, cosObjectSummaries);
            } while (objectListing.isTruncated());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        allowActions = new String[]{"name/cos:PutObject", "name/cos:PostObject", "name/cos:InitiateMultipartUpload", "name/cos:ListMultipartUploads", "name/cos:ListParts", "name/cos:UploadPart", "name/cos:CompleteMultipartUpload"};
    }
}

