/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.protocol.storage.request;

import cn.novelweb.tool.upload.fastdfs.mapper.DynamicFieldType;
import cn.novelweb.tool.upload.fastdfs.mapper.FastDfsColumn;
import cn.novelweb.tool.upload.fastdfs.model.MateData;
import cn.novelweb.tool.upload.fastdfs.protocol.BaseRequest;
import cn.novelweb.tool.upload.fastdfs.protocol.ProtocolHead;
import cn.novelweb.tool.upload.fastdfs.protocol.storage.enums.StorageMetadataSetType;
import cn.novelweb.tool.upload.fastdfs.utils.MetadataMapperUtils;
import cn.novelweb.tool.upload.fastdfs.utils.Validate;
import java.nio.charset.Charset;
import java.util.Set;

public class SetMetadataRequest
extends BaseRequest {
    @FastDfsColumn(index=0)
    private int fileNameByteLength;
    @FastDfsColumn(index=1)
    private int mataDataByteLength;
    @FastDfsColumn(index=2)
    private byte opFlag;
    @FastDfsColumn(index=3, max=16)
    private String groupName;
    @FastDfsColumn(index=4, dynamicField=DynamicFieldType.allRestByte)
    private String path;
    @FastDfsColumn(index=5, dynamicField=DynamicFieldType.mateData)
    private Set<MateData> metaDataSet;

    public SetMetadataRequest(String groupName, String path, Set<MateData> metaDataSet, StorageMetadataSetType type) {
        Validate.notBlank(groupName, "\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Validate.notBlank(path, "\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Validate.notEmpty(metaDataSet, "\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Validate.notNull(type, "\u6807\u7b7e\u8bbe\u7f6e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        this.groupName = groupName;
        this.path = path;
        this.metaDataSet = metaDataSet;
        this.opFlag = type.getType();
        this.head = new ProtocolHead(13);
    }

    @Override
    public byte[] encodeParam(Charset charset) {
        this.fileNameByteLength = this.path.getBytes(charset).length;
        this.mataDataByteLength = this.getMetaDataSetByteSize(charset);
        return super.encodeParam(charset);
    }

    private int getMetaDataSetByteSize(Charset charset) {
        return MetadataMapperUtils.toByte(this.metaDataSet, charset).length;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Set<MateData> getMetaDataSet() {
        return this.metaDataSet;
    }

    public byte getOpFlag() {
        return this.opFlag;
    }

    public String getPath() {
        return this.path;
    }

    public int getFileNameByteLength() {
        return this.fileNameByteLength;
    }

    public int getMataDataByteLength() {
        return this.mataDataByteLength;
    }
}

