/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.protocol;

import cn.novelweb.tool.upload.fastdfs.conn.Connection;
import cn.novelweb.tool.upload.fastdfs.exception.FastDfsIoException;
import cn.novelweb.tool.upload.fastdfs.protocol.BaseCommand;
import cn.novelweb.tool.upload.fastdfs.protocol.BaseRequest;
import cn.novelweb.tool.upload.fastdfs.protocol.BaseResponse;
import cn.novelweb.tool.upload.fastdfs.protocol.ProtocolHead;
import cn.novelweb.tool.upload.fastdfs.utils.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommand<T>
implements BaseCommand<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCommand.class);
    public BaseRequest request;
    public BaseResponse<T> response;

    @Override
    public T execute(Connection conn) {
        try {
            this.send(conn.getOutputStream(), conn.getCharset());
        }
        catch (IOException e) {
            throw new FastDfsIoException("Socket IO\u5f02\u5e38 \u53d1\u9001\u6d88\u606f\u5f02\u5e38", e);
        }
        try {
            return this.receive(conn.getInputStream(), conn.getCharset());
        }
        catch (IOException e) {
            throw new FastDfsIoException("Socket IO\u5f02\u5e38 \u63a5\u6536\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    private void send(OutputStream out, Charset charset) throws IOException {
        byte[] head = this.request.getHeadByte(charset);
        byte[] param = this.request.encodeParam(charset);
        InputStream inputFile = this.request.getInputFile();
        long fileSize = this.request.getFileSize();
        Log.debug("\u53d1\u51fa\u8bf7\u6c42 - \u62a5\u6587\u5934[{}], \u8bf7\u6c42\u53c2\u6570[{}]", (Object)this.request.getHead(), (Object)param);
        out.write(head);
        if (null != param) {
            out.write(param);
        }
        if (null != inputFile) {
            this.sendFileContent(inputFile, fileSize, out);
        }
    }

    private void sendFileContent(InputStream ins, long size, OutputStream ous) throws IOException {
        Log.debug("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u6d41, \u5927\u5c0f\u4e3a[{}]", (Object)size);
        long remainBytes = size;
        byte[] buff = new byte[262144];
        while (remainBytes > 0L) {
            int bytes = ins.read(buff, 0, remainBytes > (long)buff.length ? buff.length : (int)remainBytes);
            if (bytes < 0) {
                throw new IOException("\u6570\u636e\u6d41\u5df2\u7ed3\u675f, \u4e0d\u5339\u914d\u9884\u671f\u7684\u5927\u5c0f");
            }
            ous.write(buff, 0, bytes);
            Log.debug("\u5269\u4f59\u4e0a\u4f20\u6570\u636e\u91cf[{}]", (Object)(remainBytes -= (long)bytes));
        }
    }

    private T receive(InputStream in, Charset charset) throws IOException {
        ProtocolHead head = ProtocolHead.createFromInputStream(in);
        Log.debug("\u670d\u52a1\u7aef\u8fd4\u56de\u62a5\u6587\u5934{}", (Object)head);
        head.validateResponseHead();
        return this.response.decode(head, in, charset);
    }
}

