/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.mapper;

import cn.novelweb.tool.upload.fastdfs.exception.FastDfsColumnMapException;
import cn.novelweb.tool.upload.fastdfs.mapper.DynamicFieldType;
import cn.novelweb.tool.upload.fastdfs.mapper.FastDfsColumn;
import cn.novelweb.tool.upload.fastdfs.utils.BytesUtil;
import cn.novelweb.tool.upload.fastdfs.utils.MetadataMapperUtils;
import cn.novelweb.tool.upload.fastdfs.utils.ReflectionsUtils;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Set;

public class FieldMateData {
    private Field field;
    private int index;
    private int max;
    private int size;
    private int offSize;
    private DynamicFieldType dynamicFieldType;

    FieldMateData(Field mateField, int offSize) {
        FastDfsColumn column = mateField.getAnnotation(FastDfsColumn.class);
        this.field = mateField;
        this.index = column.index();
        this.max = column.max();
        this.size = this.getFieldSize(this.field);
        this.offSize = offSize;
        this.dynamicFieldType = column.dynamicField();
        if (this.max > 0 && this.size > this.max) {
            this.size = this.max;
        }
    }

    private int getFieldSize(Field field) {
        if (String.class == field.getType()) {
            return this.max;
        }
        if (Long.TYPE == field.getType()) {
            return 8;
        }
        if (Integer.TYPE == field.getType()) {
            return 8;
        }
        if (Date.class == field.getType()) {
            return 8;
        }
        if (Byte.TYPE == field.getType()) {
            return 1;
        }
        if (Boolean.TYPE == field.getType()) {
            return 1;
        }
        if (Set.class == field.getType()) {
            return 0;
        }
        throw new FastDfsColumnMapException(field.getName() + "\u83b7\u53d6Field\u5927\u5c0f\u65f6\u672a\u8bc6\u522b\u7684FastDFSColumn\u7c7b\u578b" + field.getType());
    }

    public Object getValue(byte[] bs, Charset charset) {
        if (String.class == this.field.getType()) {
            if (this.isDynamicField()) {
                return new String(bs, this.offSize, bs.length - this.offSize, charset).trim();
            }
            return new String(bs, this.offSize, this.size, charset).trim();
        }
        if (Long.TYPE == this.field.getType()) {
            return BytesUtil.buff2long(bs, this.offSize);
        }
        if (Integer.TYPE == this.field.getType()) {
            return (int)BytesUtil.buff2long(bs, this.offSize);
        }
        if (Date.class == this.field.getType()) {
            return new java.sql.Date(BytesUtil.buff2long(bs, this.offSize) * 1000L);
        }
        if (Byte.TYPE == this.field.getType()) {
            return bs[this.offSize];
        }
        if (Boolean.TYPE == this.field.getType()) {
            return bs[this.offSize] != 0;
        }
        throw new FastDfsColumnMapException(this.field.getName() + "\u83b7\u53d6\u503c\u65f6\u672a\u8bc6\u522b\u7684FdfsColumn\u7c7b\u578b" + this.field.getType());
    }

    int getRealSize() {
        if (this.isDynamicField()) {
            return 0;
        }
        return this.size;
    }

    public byte[] toByte(Object bean, Charset charset) {
        Object value = this.getFieldValue(bean);
        if (this.isDynamicField()) {
            return this.getDynamicFieldByteValue(value, charset);
        }
        if (String.class.equals(this.field.getType())) {
            return BytesUtil.objString2Byte((String)value, this.max, charset);
        }
        if (Long.TYPE.equals(this.field.getType())) {
            return BytesUtil.long2buff((Long)value);
        }
        if (Integer.TYPE.equals(this.field.getType())) {
            return BytesUtil.long2buff(((Integer)value).intValue());
        }
        if (java.sql.Date.class.equals(this.field.getType())) {
            throw new FastDfsColumnMapException("Date \u8fd8\u4e0d\u652f\u6301");
        }
        if (Byte.TYPE.equals(this.field.getType())) {
            byte[] result = new byte[]{(Byte)value};
            return result;
        }
        if (Boolean.TYPE.equals(this.field.getType())) {
            throw new FastDfsColumnMapException("boolean \u8fd8\u4e0d\u652f\u6301");
        }
        throw new FastDfsColumnMapException("\u5c06\u5c5e\u6027\u503c\u8f6c\u6362\u4e3abyte\u65f6\u672a\u8bc6\u522b\u7684FdfsColumn\u7c7b\u578b" + this.field.getName());
    }

    private byte[] getDynamicFieldByteValue(Object value, Charset charset) {
        switch (this.dynamicFieldType) {
            case allRestByte: {
                return this.objString2Byte(value, charset);
            }
            case mateData: {
                return MetadataMapperUtils.toByte((Set)value, charset);
            }
        }
        return BytesUtil.objString2Byte((String)value, charset);
    }

    private byte[] objString2Byte(Object value, Charset charset) {
        return BytesUtil.objString2Byte((String)value, charset);
    }

    private Object getFieldValue(Object bean) {
        return ReflectionsUtils.getFieldValue(bean, this.field.getName());
    }

    int getDynamicFieldByteSize(Object bean, Charset charset) {
        Object value = ReflectionsUtils.getFieldValue(bean, this.field.getName());
        if (null == value) {
            return 0;
        }
        switch (this.dynamicFieldType) {
            case allRestByte: {
                return ((String)value).getBytes(charset).length;
            }
            case mateData: {
                return MetadataMapperUtils.toByte((Set)value, charset).length;
            }
        }
        return this.getFieldSize(this.field);
    }

    public boolean isDynamicField() {
        return !DynamicFieldType.NULL.equals((Object)this.dynamicFieldType);
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public int getIndex() {
        return this.index;
    }

    public int getMax() {
        return this.max;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffSize() {
        return this.offSize;
    }

    public DynamicFieldType getDynamicFieldType() {
        return this.dynamicFieldType;
    }

    public String toString() {
        return "FieldMateData{field=" + this.getFieldName() + ", index=" + this.index + ", max=" + this.max + ", size=" + this.size + ", offSize=" + this.offSize + ", dynamicFieldType=" + (Object)((Object)this.dynamicFieldType) + '}';
    }
}

