/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.http;

import cn.novelweb.config.ConstantConfiguration;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

@ApiModel(value="\u8fd4\u56de\u4fe1\u606f")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u72b6\u6001\u7801")
    private String code;
    @ApiModelProperty(value="\u63cf\u8ff0")
    private String message;
    @ApiModelProperty(value="\u5bf9\u8c61")
    private T data;

    private Result(String code, String message) {
        this.code = code;
        this.message = message;
    }

    private Result(String code, String message, T obj) {
        this.code = code;
        this.message = message;
        this.data = obj;
    }

    public static boolean isSuccess(@Nullable Result<?> result) {
        return Optional.ofNullable(result).map(x -> ObjectUtils.nullSafeEquals((Object)ConstantConfiguration.success, (Object)x.code)).orElse(Boolean.FALSE);
    }

    public static boolean isNotSuccess(@Nullable Result<?> result) {
        return !Result.isSuccess(result);
    }

    public static <T> Result<T> ok(T data) {
        return new Result<T>(ConstantConfiguration.success, "\u8bf7\u6c42\u6210\u529f", data);
    }

    public static <T> Result<T> ok() {
        return new Result<T>(ConstantConfiguration.success, "\u8bf7\u6c42\u6210\u529f");
    }

    public static <T> Result<T> ok(String code, String message) {
        return new Result<T>(code, message);
    }

    public static <T> Result<T> ok(int code, String message) {
        return new Result<T>(String.valueOf(code), message);
    }

    public static <T> Result<T> ok(String code, String message, T data) {
        return new Result<T>(code, message, data);
    }

    public static <T> Result<T> ok(int code, String message, T data) {
        return new Result<T>(String.valueOf(code), message, data);
    }

    public static <T> Result<T> fail(T data) {
        return new Result<T>(ConstantConfiguration.fail, "\u8bf7\u6c42\u5931\u8d25", data);
    }

    public static <T> Result<T> fail() {
        return new Result<Object>(ConstantConfiguration.fail, "\u8bf7\u6c42\u5931\u8d25", null);
    }

    public static <T> Result<T> fail(String message) {
        return new Result<Object>(ConstantConfiguration.fail, message, null);
    }

    public static <T> Result<T> fail(String code, String message) {
        return new Result<T>(code, message);
    }

    public static <T> Result<T> fail(int code, String message) {
        return new Result<T>(String.valueOf(code), message);
    }

    public static <T> Result<T> fail(String code, String message, T data) {
        return new Result<T>(code, message, data);
    }

    public static <T> Result<T> fail(int code, String message, T data) {
        return new Result<T>(String.valueOf(code), message, data);
    }

    public static <T> Result<T> authority(String message) {
        return new Result<Object>(ConstantConfiguration.noAuthority, message, null);
    }

    public static <T> Result<T> authority() {
        return new Result<Object>(ConstantConfiguration.noAuthority, "\u62b1\u6b49\uff01\u60a8\u6ca1\u6709\u5bf9\u5e94\u7684\u6743\u9650", null);
    }

    public static <T> Result<T> refuse() {
        return new Result<Object>(ConstantConfiguration.refuse, "\u767b\u5f55\u8fc7\u671f\uff01\u8bf7\u91cd\u65b0\u767b\u5f55", null);
    }

    public static <T> Result<T> refuse(String message) {
        return new Result<Object>(ConstantConfiguration.refuse, message, null);
    }

    public static <T> Result<T> error(String message) {
        return new Result<Object>(ConstantConfiguration.systemError, message, null);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Result() {
    }
}

