/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.annotation.log.util;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import cn.novelweb.annotation.log.pojo.AccessLogInfo;
import cn.novelweb.annotation.log.util.SpiderUtils;
import cn.novelweb.ip.IpUtils;
import cn.novelweb.ip.Region;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class Annotation {
    public static <A extends java.lang.annotation.Annotation> A getAnnotation(JoinPoint joinPoint, Class<A> annotationClass) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(annotationClass);
        }
        return null;
    }

    public static AccessLogInfo initInfo(String title, boolean isGetIp, Exception e) {
        UserAgent ua;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        AccessLogInfo accessLogInfo = AccessLogInfo.builder().ip("127.0.0.1").requestUri("").location("0-0-\u5185\u7f51IP \u5185\u7f51IP").build();
        String userAgent = "\u65e0\u6cd5\u83b7\u53d6User-Agent\u4fe1\u606f";
        if (requestAttributes != null) {
            userAgent = requestAttributes.getRequest().getHeader("User-Agent");
            accessLogInfo.setIp(ServletUtil.getClientIP((HttpServletRequest)requestAttributes.getRequest(), (String[])new String[0]));
            accessLogInfo.setRequestUri(requestAttributes.getRequest().getRequestURI());
            accessLogInfo.setMethod(requestAttributes.getRequest().getMethod());
            accessLogInfo.setRequest(requestAttributes.getRequest());
        }
        Future future = null;
        if (isGetIp) {
            future = ThreadUtil.execAsync(() -> IpUtils.getIpLocationByBtree(accessLogInfo.getIp()));
        }
        if ((ua = UserAgentUtil.parse((String)userAgent)) != null) {
            accessLogInfo.setBrowser(ua.getBrowser().toString());
            accessLogInfo.setBrowserVersion(ua.getVersion());
            accessLogInfo.setBrowserEngine(ua.getEngine().toString());
            accessLogInfo.setBrowserEngineVersion(ua.getEngineVersion());
            accessLogInfo.setIsMobile(ua.isMobile());
            accessLogInfo.setOs(ua.getOs().toString());
            accessLogInfo.setPlatform(ua.getPlatform().getName());
        }
        accessLogInfo.setSpider(SpiderUtils.parseSpiderType(userAgent));
        accessLogInfo.setUserAgent(userAgent);
        accessLogInfo.setTitle(title);
        accessLogInfo.setStatus(e != null ? 1 : 0);
        accessLogInfo.setCreateTime(new Date());
        if (e != null) {
            if (e.getCause() != null) {
                accessLogInfo.setErrorCause(e.getCause().toString());
                accessLogInfo.setErrorMsg(e.getCause().getMessage());
            } else {
                accessLogInfo.setErrorCause(e.getLocalizedMessage());
                accessLogInfo.setErrorMsg(e.getMessage());
            }
        } else {
            accessLogInfo.setErrorCause("");
            accessLogInfo.setErrorMsg("");
        }
        if (future != null) {
            try {
                Region region = (Region)future.get();
                accessLogInfo.setLocation(region.getCountry() + "-" + region.getProvince() + "-" + region.getCity() + " " + region.getIsp());
            }
            catch (Exception e1) {
                accessLogInfo.setErrorCause(e1.getCause().toString());
                accessLogInfo.setErrorMsg(e1.getCause().getMessage());
                accessLogInfo.setStatus(1);
            }
        }
        return accessLogInfo;
    }
}

