/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.annotation.log.realize;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.novelweb.annotation.TaskCallback;
import cn.novelweb.annotation.log.OpLog;
import cn.novelweb.annotation.log.callback.OpLogCompletionHandler;
import cn.novelweb.annotation.log.pojo.OpLogInfo;
import cn.novelweb.annotation.log.util.Annotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class OpLogAspect {
    private static final Logger log = LoggerFactory.getLogger(OpLogAspect.class);

    @Pointcut(value="@annotation(cn.novelweb.annotation.log.OpLog)")
    public void opLog() {
    }

    @AfterReturning(pointcut="opLog()")
    public void doBefore(JoinPoint joinPoint) {
        try {
            this.handleLog(joinPoint, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterThrowing(value="opLog()", throwing="e")
    public void doAfter(JoinPoint joinPoint, Exception e) {
        try {
            this.handleLog(joinPoint, e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void handleLog(JoinPoint joinPoint, Exception e) {
        OpLog opLog = Annotation.getAnnotation(joinPoint, OpLog.class);
        if (opLog == null) {
            log.info("Failed to get the annotation information correctly...");
            return;
        }
        OpLogInfo opLogInfo = new OpLogInfo();
        BeanUtils.copyProperties((Object)Annotation.initInfo(opLog.title(), opLog.isGetIp(), e), (Object)opLogInfo);
        opLogInfo.setBusinessType(opLog.businessType());
        opLogInfo.setClassName(joinPoint.getTarget().getClass().getName());
        opLogInfo.setMethodName(joinPoint.getSignature().getName());
        if (opLog.isSaveRequestData()) {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null) {
                if (MapUtil.isEmpty((Map)requestAttributes.getRequest().getParameterMap())) {
                    Object[] args = joinPoint.getArgs();
                    if (ArrayUtil.isEmpty((Object[])args)) {
                        opLogInfo.setParameter("");
                    } else {
                        String parameter;
                        List<Object> objectList = Arrays.asList(args);
                        try {
                            parameter = JSON.toJSONString(objectList.stream().filter(arg -> !(arg instanceof HttpServletRequest) && !(arg instanceof HttpServletResponse)).collect(Collectors.toList()));
                        }
                        catch (Exception exception) {
                            parameter = "";
                        }
                        opLogInfo.setParameter(parameter);
                    }
                } else {
                    opLogInfo.setParameter(JSONObject.toJSONString((Object)requestAttributes.getRequest().getParameterMap()));
                }
            } else {
                opLogInfo.setParameter("\u65e0\u6cd5\u83b7\u53d6request\u4fe1\u606f");
            }
        }
        ThreadUtil.execAsync(() -> TaskCallback.callback(OpLogCompletionHandler.class, opLogInfo));
    }
}

