package cn.nkpro.elcube.plugins.esign.model;

import lombok.Data;

import java.util.List;

@Data
public class PsnAuth {

    /**
     * 个人认证配置
     * （psnAccount与psnId二选一传入，
     * 不可同时传入，也不可同时不传）
     */
    private PsnAuthConfig psnAuthConfig;

    /**
     * 个人授权配置项
     * （授权有效期默认30天）
     * 不传此参数默认页面仅实名认证，不需要用户授权
     */
    private AuthorizeConfig authorizeConfig;

    /**
     * 接收回调通知的Web地址
     * 通知开发者用户认证和授权的完成以及变更情况
     * 需要符合 https /http 协议地址
     */
    private String notifyUrl;
    /**
     * 指定客户端类型，默认ALL
     * ALL - 自动适配移动端或PC端
     * H5  - 移动端适配
     * PC  - PC端适配
     */
    private String clientType;

    /**
     * 认证完成重定向配置项
     */
    private RedirectConfig redirectConfig;

    /**
     * AppScheme，用于支付宝人脸认证重定向时唤起指定App。示例：
     * appScheme=xxxdev://cn.demo/signBackPage
     */
    private String appScheme;

    @Data
    public static class PsnAuthConfig{
        /**
         * 个人用户账号标识（手机号或邮箱）
         * （若未知用户的psnId/用户未实名，请传此字段）
         */
        private String psnAccount;
        /**
         * 个人账号ID
         * （若已知用户的psnId/用户已实名，请传此字段）
         */
        private String psnId;

        /**
         * 个人身份附加信息
         */
        private PsnInfo psnInfo;

        /**
         * 个人实名认证页面设置
         */
        private PsnAuthPageConfig psnAuthPageConfig;
    }

    @Data
    public static class PsnInfo{
        /**
         * 姓名
         */
        private String psnName;
        /**
         * 证件号码
         */
        private String psnIDCardNum;

        /**
         * 证件类型
         * CRED_PSN_CH_IDCARD【中国大陆居民身份证】
         * CRED_PSN_CH_HONGKONG【香港来往大陆通行证】
         * CRED_PSN_CH_MACAO【澳门来往大陆通行证】
         * CRED_PSN_CH_TWCARD【台湾来往大陆通行证】
         * CRED_PSN_PASSPORT【护照】
         */
        private String psnIDCardType;

        /**
         * 个人手机号（运营商实名登记手机号或银行卡预留手机号，仅用于认证）
         */
        private String psnMobile;

        /**
         * 个人银行卡号
         */
        private String bankCardNum;
    }

    @Data
    public static class PsnAuthPageConfig{
        /**
         * 设置页面中默认选择的实名认证方式
         * PSN_BANKCARD4 - 银行卡四要素认证
         * PSN_MOBILE3 - 手机运营商三要素认证
         * PSN_FACE - 人脸识别认证
         */
        private String psnDefaultauthMode;
        /**
         * 设置页面中可选择的个人认证方式范围，
         * 若不传此参数，则可选择全部认证方式。
         * 枚举值同上（psnDefaultauthMode）
         */
        private List<String> psnAvailableauthModes;
        /**
         * 设置页面中允许编辑的个人信息字段
         * name - 姓名
         * IDCardNum - 证件号码
         * mobile - 个人手机号（仅针对实名认证手机号）
         * bankCardNum - 个人银行卡号
         */
        private List<String> psnEditableFields;

    }

    @Data
    public static class AuthorizeConfig{
        /**
         * 设置页面中可选择的授权范围
         * get_psn_identity_info
         * 授权允许获取个人用户的账号基本信息
         * psn_initiate_sign
         *  授权允许代替个人用户发起合同签署
         * manage_psn_resource
         * 授权允许获取个人用户的印章等资源的管理权限
         */
        private List<String> authorizedScopes;
    }

    @Data
    public static class RedirectConfig{
        /**
         * 操作完成后页面重定向跳转延迟时间，单位为秒，默认3秒。
         * 0-不展示完成结果页，认证完成直接跳转重定向地址。
         * 3-展示完成结果页，倒计时3秒后，自动跳转重定向地址
         * 注：当redirectUrl不传的情况下，该字段无需传入，默认认证完成结果页不跳转。
         */
        private String redirectDelayTime;
        /**
         * 认证完成后跳转页面（需符合 https /http 协议地址）
         */
        private String redirectUrl;
    }
}
