/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.plugins.esign;

import cn.nkpro.elcube.plugins.esign.ESignDefineException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Encryption {
    private Encryption() {
    }

    public static String appendSignDataString(String method, String accept, String contentMD5, String contentType, String date, String headers, String url) {
        StringBuffer sb = new StringBuffer();
        sb.append(method).append("\n").append(accept).append("\n").append(contentMD5).append("\n").append(contentType).append("\n").append(date).append("\n");
        if ("".equals(headers)) {
            sb.append(headers).append(url);
        } else {
            sb.append(headers).append("\n").append(url);
        }
        return new String(sb);
    }

    public static String doContentMD5(String str) throws ESignDefineException {
        byte[] md5Bytes = null;
        MessageDigest md5 = null;
        String contentMD5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            md5.update(str.getBytes("UTF-8"));
            md5Bytes = md5.digest();
            contentMD5 = Base64.getEncoder().encodeToString(md5Bytes);
        }
        catch (NoSuchAlgorithmException e) {
            ESignDefineException ex = new ESignDefineException("\u4e0d\u652f\u6301\u6b64\u7b97\u6cd5", e);
            ex.initCause(e);
            throw ex;
        }
        catch (UnsupportedEncodingException e) {
            ESignDefineException ex = new ESignDefineException("\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u7f16\u7801", e);
            ex.initCause(e);
            throw ex;
        }
        return contentMD5;
    }

    public static String doSignatureBase64(String message, String secret) throws ESignDefineException {
        String algorithm = "HmacSHA256";
        String digestBase64 = null;
        try {
            Mac hmacSha256 = Mac.getInstance(algorithm);
            byte[] keyBytes = secret.getBytes("UTF-8");
            byte[] messageBytes = message.getBytes("UTF-8");
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, algorithm));
            byte[] digestBytes = hmacSha256.doFinal(messageBytes);
            digestBase64 = Base64.getEncoder().encodeToString(digestBytes);
        }
        catch (NoSuchAlgorithmException e) {
            ESignDefineException ex = new ESignDefineException("\u4e0d\u652f\u6301\u6b64\u7b97\u6cd5", e);
            ex.initCause(e);
            throw ex;
        }
        catch (UnsupportedEncodingException e) {
            ESignDefineException ex = new ESignDefineException("\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u7f16\u7801", e);
            ex.initCause(e);
            throw ex;
        }
        catch (InvalidKeyException e) {
            ESignDefineException ex = new ESignDefineException("\u65e0\u6548\u7684\u5bc6\u94a5\u89c4\u8303", e);
            ex.initCause(e);
            throw ex;
        }
        return digestBase64;
    }

    public static String timeStamp() {
        long timeStamp = System.currentTimeMillis();
        return String.valueOf(timeStamp);
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String Hmac_SHA256(String message, String key) throws ESignDefineException {
        byte[] rawHmac = null;
        try {
            SecretKeySpec sk = new SecretKeySpec(key.getBytes(), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(sk);
            rawHmac = mac.doFinal(message.getBytes());
            return Encryption.byteArrayToHexString(rawHmac);
        }
        catch (InvalidKeyException e) {
            try {
                ESignDefineException ex = new ESignDefineException("\u65e0\u6548\u7684\u5bc6\u94a5\u89c4\u8303", e);
                ex.initCause(e);
                throw ex;
                catch (NoSuchAlgorithmException e2) {
                    ex = new ESignDefineException("\u4e0d\u652f\u6301\u6b64\u7b97\u6cd5", e2);
                    ex.initCause(e2);
                    throw ex;
                }
                catch (Exception e3) {
                    ex = new ESignDefineException("hash\u6563\u5217\u52a0\u5bc6\u7b97\u6cd5\u62a5\u9519", e3);
                    ex.initCause(e3);
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                return Encryption.byteArrayToHexString(rawHmac);
            }
        }
    }

    public static String MD5Digest(String text) throws ESignDefineException {
        byte[] digest = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(text.getBytes());
            digest = md5.digest();
        }
        catch (NoSuchAlgorithmException e) {
            try {
                ESignDefineException ex = new ESignDefineException("\u4e0d\u652f\u6301\u6b64\u7b97\u6cd5", e);
                ex.initCause(e);
                throw ex;
            }
            catch (Throwable throwable) {
                return Encryption.byteArrayToHexString(digest);
            }
        }
        return Encryption.byteArrayToHexString(digest);
    }
}

