/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.plugins.esign;

import cn.nkpro.elcube.co.http.NkAbstractHttpClient;
import cn.nkpro.elcube.co.http.NkHttpResponse;
import cn.nkpro.elcube.plugins.esign.ESignDefineException;
import cn.nkpro.elcube.plugins.esign.ESignProperties;
import cn.nkpro.elcube.plugins.esign.Encryption;
import cn.nkpro.elcube.plugins.esign.HeaderConstant;
import cn.nkpro.elcube.plugins.esign.model.PsnAuth;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class ESignService
extends NkAbstractHttpClient {
    @Autowired
    private ESignProperties signProperties;

    public NkHttpResponse request(String url, Object body) throws ESignDefineException {
        String content = JSON.toJSONString((Object)body);
        System.out.println(content);
        String contentMd5 = Encryption.doContentMD5(content);
        String message = Encryption.appendSignDataString("POST", HeaderConstant.ACCEPT.VALUE(), contentMd5, HeaderConstant.CONTENTTYPE_JSON.VALUE(), HeaderConstant.DATE.VALUE(), HeaderConstant.HEADERS.VALUE(), url);
        String reqSignature = Encryption.doSignatureBase64(message, this.signProperties.getAppSecret());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Tsign-Open-App-Id", this.signProperties.getAppId());
        headers.put("X-Tsign-Open-Auth-Mode", "Signature");
        headers.put("X-Tsign-Open-Ca-Signature", reqSignature);
        headers.put("X-Tsign-Open-Ca-Timestamp", String.valueOf(System.currentTimeMillis()));
        headers.put("Accept", HeaderConstant.ACCEPT.VALUE());
        headers.put("Content-Type", HeaderConstant.CONTENTTYPE_JSON.VALUE());
        headers.put("Content-MD5", contentMd5);
        return this.doPost(this.signProperties.getHost() + url, headers, content);
    }

    public static void main(String[] args) {
        ESignService eSign = new ESignService();
        PsnAuth auth = new PsnAuth();
        auth.setPsnAuthConfig(new PsnAuth.PsnAuthConfig());
        auth.getPsnAuthConfig().setPsnAccount("mailxbs@126.com");
        try {
            eSign.request("/v3/psn-auth-url", auth);
        }
        catch (ESignDefineException e) {
            e.printStackTrace();
        }
    }
}

